/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.store.impl.CommandCredentialStore;

public class CmdPasswordStore
extends CommandCredentialStore {
    public static final String CMD_PASSWORD_STORE = "CmdPasswordStore";
    public static final String SUPPORTED_CMD_TYPE = "CMD";

    public CmdPasswordStore() {
        this.storeName = "cmd";
    }

    @Override
    char[] executePasswordCommand(String passwordCommand) throws Throwable {
        String passwordCmdLine;
        String passwordCmdType;
        if (passwordCommand.trim().startsWith("{CMD")) {
            StringTokenizer tokenizer = new StringTokenizer(passwordCommand, "{}");
            passwordCmdType = tokenizer.nextToken();
            passwordCmdLine = tokenizer.nextToken();
        } else {
            passwordCmdType = SUPPORTED_CMD_TYPE;
            passwordCmdLine = passwordCommand;
        }
        if (!passwordCmdType.equals(SUPPORTED_CMD_TYPE)) {
            throw ElytronMessages.log.cacheForExternalCommandsNotSupported();
        }
        try {
            return this.execCmd(passwordCmdLine);
        }
        catch (Exception e) {
            throw ElytronMessages.log.passwordCommandExecutionProblem(this.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private char[] execCmd(String command) throws Exception {
        String line;
        ProcessBuilder builder = new ProcessBuilder(this.parseCommand(command));
        Process process = builder.start();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            line = reader.readLine();
        }
        int exitCode = process.waitFor();
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("Exit code from password command = %d", exitCode);
        }
        return line != null ? line.toCharArray() : null;
    }

    private String[] parseCommand(String command) {
        String[] parsedCommand = command.split("(?<!\\\\),");
        for (int k = 0; k < parsedCommand.length; ++k) {
            if (parsedCommand[k].indexOf(92) == -1) continue;
            parsedCommand[k] = parsedCommand[k].replaceAll("\\\\,", ",");
        }
        return parsedCommand;
    }
}

