/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.Provider;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.keystore.LdapKeyStoreSpi;

public class LdapKeyStore
extends KeyStore {
    protected LdapKeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String type) {
        super(keyStoreSpi, provider, type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final int DEFAULT_SEARCH_TIME_LIMIT = 10000;
        private ExceptionSupplier<DirContext, NamingException> dirContextSupplier;
        private String searchPath;
        private int searchScope = 2;
        private int searchTimeLimit = 10000;
        private String filterAlias;
        private String filterCertificate;
        private String filterIterate;
        private LdapName createPath;
        private String createRdn = "cn";
        private Attributes createAttributes;
        private String aliasAttribute = "cn";
        private String certificateAttribute = "usercertificate";
        private String certificateType = "X.509";
        private String certificateChainAttribute = "userSMIMECertificate";
        private String certificateChainEncoding = "PKCS7";
        private String keyAttribute = "userPKCS12";
        private String keyType = "PKCS12";

        private Builder() {
        }

        public LdapKeyStore build() {
            Assert.checkNotNullParam((String)"dirContextSupplier", this.dirContextSupplier);
            Assert.checkNotNullParam((String)"searchPath", (Object)this.searchPath);
            Assert.checkNotNullParam((String)"searchScope", (Object)this.searchScope);
            Assert.checkNotNullParam((String)"searchTimeLimit", (Object)this.searchTimeLimit);
            Assert.checkNotNullParam((String)"aliasAttribute", (Object)this.aliasAttribute);
            Assert.checkNotNullParam((String)"certificateAttribute", (Object)this.certificateAttribute);
            Assert.checkNotNullParam((String)"certificateType", (Object)this.certificateType);
            Assert.checkNotNullParam((String)"certificateChainAttribute", (Object)this.certificateChainAttribute);
            Assert.checkNotNullParam((String)"certificateChainEncoding", (Object)this.certificateChainEncoding);
            Assert.checkNotNullParam((String)"keyAttribute", (Object)this.keyAttribute);
            Assert.checkNotNullParam((String)"keyType", (Object)this.keyType);
            if (this.filterAlias == null) {
                this.filterAlias = "(" + this.aliasAttribute + "={0})";
            }
            if (this.filterCertificate == null) {
                this.filterCertificate = "(" + this.certificateAttribute + "={0})";
            }
            if (this.filterIterate == null) {
                this.filterIterate = "(" + this.aliasAttribute + "=*)";
            }
            LdapKeyStoreSpi spi = new LdapKeyStoreSpi(this.dirContextSupplier, this.searchPath, this.searchScope, this.searchTimeLimit, this.filterAlias, this.filterCertificate, this.filterIterate, this.createPath, this.createRdn, this.createAttributes, this.aliasAttribute, this.certificateAttribute, this.certificateType, this.certificateChainAttribute, this.certificateChainEncoding, this.keyAttribute, this.keyType);
            return new LdapKeyStore(spi, null, null);
        }

        public Builder setDirContextSupplier(ExceptionSupplier<DirContext, NamingException> dirContextSupplier) {
            this.dirContextSupplier = dirContextSupplier;
            return this;
        }

        public Builder setSearchPath(String searchPath) {
            this.searchPath = searchPath;
            return this;
        }

        public Builder setSearchScope(int searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        public Builder setSearchRecursive(boolean recursive) {
            this.searchScope = recursive ? 2 : 1;
            return this;
        }

        public Builder setSearchTimeLimit(int searchTimeLimit) {
            this.searchTimeLimit = searchTimeLimit;
            return this;
        }

        public Builder setFilterAlias(String filterAlias) {
            this.filterAlias = filterAlias;
            return this;
        }

        public Builder setFilterCertificate(String filterCertificate) {
            this.filterCertificate = filterCertificate;
            return this;
        }

        public Builder setFilterIterate(String filterIterate) {
            this.filterIterate = filterIterate;
            return this;
        }

        public Builder setCreatePath(LdapName createPath) {
            this.createPath = createPath;
            return this;
        }

        public Builder setCreateRdn(String createRdn) {
            this.createRdn = createRdn;
            return this;
        }

        public Builder setCreateAttributes(Attributes createAttributes) {
            this.createAttributes = createAttributes;
            return this;
        }

        public Builder setAliasAttribute(String aliasAttribute) {
            this.aliasAttribute = aliasAttribute;
            return this;
        }

        public Builder setCertificateAttribute(String certificateAttribute) {
            this.certificateAttribute = certificateAttribute;
            return this;
        }

        public Builder setCertificateType(String certificateType) {
            this.certificateType = certificateType;
            return this;
        }

        public Builder setCertificateChainAttribute(String certificateChainAttribute) {
            this.certificateChainAttribute = certificateChainAttribute;
            return this;
        }

        public Builder setCertificateChainEncoding(String certificateChainEncoding) {
            this.certificateChainEncoding = certificateChainEncoding;
            return this;
        }

        public Builder setKeyAttribute(String keyAttribute) {
            this.keyAttribute = keyAttribute;
            return this;
        }

        public Builder setKeyType(String keyType) {
            this.keyType = keyType;
            return this;
        }
    }
}

