/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

class SetCredentialsConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.CredentialSetting {
    private final CredentialSource credentialSource;

    SetCredentialsConfiguration(AuthenticationConfiguration parent, CredentialSource credentialSource) {
        super(parent.without(AuthenticationConfiguration.CredentialSetting.class));
        this.credentialSource = credentialSource;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        Callback callback = callbacks[index];
        if (callback instanceof CredentialCallback) {
            CredentialCallback credentialCallback = (CredentialCallback)callback;
            Credential credential = this.credentialSource.getCredential(credentialCallback.getCredentialType(), credentialCallback.getAlgorithm());
            if (credential != null && credentialCallback.isCredentialSupported(credential)) {
                credentialCallback.setCredential(credential);
                return;
            }
        } else if (callback instanceof PasswordCallback) {
            PasswordCallback passwordCallback = (PasswordCallback)callback;
            CredentialSource credentials = this.credentialSource;
            if (credentials != null) {
                TwoWayPassword password = credentials.applyToCredential(PasswordCredential.class, "clear", c -> c.getPassword(TwoWayPassword.class));
                if (password instanceof ClearPassword) {
                    passwordCallback.setPassword(((ClearPassword)password).getPassword());
                    return;
                }
                if (password != null) {
                    try {
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                        ClearPasswordSpec clearPasswordSpec = passwordFactory.getKeySpec(passwordFactory.translate(password), ClearPasswordSpec.class);
                        passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                        return;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        // empty catch block
                    }
                }
            }
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        Set<Class<? extends Credential>> types = SaslMechanismInformation.getSupportedClientCredentialTypes(mechanismName);
        CredentialSource credentials = this.credentialSource;
        for (Class<? extends Credential> type : types) {
            if (AlgorithmCredential.class.isAssignableFrom(type)) {
                Set<String> algorithms = SaslMechanismInformation.getSupportedClientCredentialAlgorithms(mechanismName, type);
                if (algorithms.contains("*")) {
                    try {
                        if (!credentials.getCredentialAcquireSupport(type, null).mayBeSupported()) continue;
                        return true;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                for (String algorithm : algorithms) {
                    try {
                        if (!credentials.getCredentialAcquireSupport(type, algorithm).mayBeSupported()) continue;
                        return true;
                    }
                    catch (IOException iOException) {
                    }
                }
                continue;
            }
            try {
                if (!credentials.getCredentialAcquireSupport(type).mayBeSupported()) continue;
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return super.filterOneSaslMechanism(mechanismName);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetCredentialsConfiguration(newParent, this.credentialSource);
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("Credentials,");
    }
}

