/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.IOException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.Rdn;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.IdentitySharedExclusiveLock;
import org.wildfly.security.auth.realm.ldap.AttributeMapping;
import org.wildfly.security.auth.realm.ldap.CredentialLoader;
import org.wildfly.security.auth.realm.ldap.CredentialPersister;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.server.CloseableIterator;
import org.wildfly.security.auth.server.IdentityLocator;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;

class LdapSecurityRealm
implements ModifiableSecurityRealm {
    private final Supplier<Provider[]> providers;
    private final ExceptionSupplier<DirContext, NamingException> dirContextSupplier;
    private final NameRewriter nameRewriter;
    private final IdentityMapping identityMapping;
    private final int pageSize;
    private final List<CredentialLoader> credentialLoaders;
    private final List<CredentialPersister> credentialPersisters;
    private final List<EvidenceVerifier> evidenceVerifiers;
    private final ConcurrentHashMap<String, IdentitySharedExclusiveLock> realmIdentityLocks = new ConcurrentHashMap();

    LdapSecurityRealm(Supplier<Provider[]> providers, ExceptionSupplier<DirContext, NamingException> dirContextSupplier, NameRewriter nameRewriter, IdentityMapping identityMapping, List<CredentialLoader> credentialLoaders, List<CredentialPersister> credentialPersisters, List<EvidenceVerifier> evidenceVerifiers, int pageSize) {
        this.providers = providers;
        this.dirContextSupplier = dirContextSupplier;
        this.nameRewriter = nameRewriter;
        this.identityMapping = identityMapping;
        this.pageSize = pageSize;
        this.credentialLoaders = credentialLoaders;
        this.credentialPersisters = credentialPersisters;
        this.evidenceVerifiers = evidenceVerifiers;
    }

    @Override
    public RealmIdentity getRealmIdentity(IdentityLocator locator) throws RealmUnavailableException {
        return this.getRealmIdentity(locator, false);
    }

    @Override
    public ModifiableRealmIdentity getRealmIdentityForUpdate(IdentityLocator locator) {
        return this.getRealmIdentity(locator, true);
    }

    private ModifiableRealmIdentity getRealmIdentity(IdentityLocator locator, boolean exclusive) {
        if (!locator.hasName()) {
            return ModifiableRealmIdentity.NON_EXISTENT;
        }
        String name = this.nameRewriter.rewriteName(locator.getName());
        if (name == null) {
            throw ElytronMessages.log.invalidName();
        }
        IdentitySharedExclusiveLock realmIdentityLock = this.getRealmIdentityLockForName(name);
        IdentitySharedExclusiveLock.IdentityLock lock = exclusive ? realmIdentityLock.lockExclusive() : realmIdentityLock.lockShared();
        return new LdapRealmIdentity(name, lock);
    }

    private DirContext obtainContext() throws RealmUnavailableException {
        try {
            return (DirContext)this.dirContextSupplier.get();
        }
        catch (NamingException e) {
            throw ElytronMessages.log.ldapRealmFailedToObtainContext(e);
        }
    }

    private void closeContext(DirContext dirContext) {
        try {
            dirContext.close();
        }
        catch (NamingException e) {
            ElytronMessages.log.debug("LdapSecurityRealm failed to close DirContext", e);
        }
    }

    @Override
    public CloseableIterator<ModifiableRealmIdentity> getRealmIdentityIterator() throws RealmUnavailableException {
        if (this.identityMapping.iteratorFilter == null) {
            throw ElytronMessages.log.ldapRealmNotConfiguredToSupportIteratingOverIdentities();
        }
        return new CloseableIterator<ModifiableRealmIdentity>(){
            private List<ModifiableRealmIdentity> list = new LinkedList<ModifiableRealmIdentity>();
            private byte[] cookie = null;
            private boolean end = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadNextPage(LdapContext context) throws NamingException, IOException {
                context.setRequestControls(new Control[]{new PagedResultsControl(LdapSecurityRealm.this.pageSize, this.cookie, true)});
                try (NamingEnumeration<SearchResult> result = context.search(LdapSecurityRealm.this.identityMapping.searchDn, LdapSecurityRealm.this.identityMapping.iteratorFilter, LdapSecurityRealm.this.createSearchControls(new String[]{LdapSecurityRealm.this.identityMapping.rdnIdentifier}));){
                    while (result.hasMore()) {
                        SearchResult entry = result.next();
                        String name = (String)entry.getAttributes().get(LdapSecurityRealm.this.identityMapping.rdnIdentifier).get();
                        this.list.add(LdapSecurityRealm.this.getRealmIdentityForUpdate(IdentityLocator.fromName(name)));
                    }
                }
                Control[] controls = context.getResponseControls();
                if (controls != null) {
                    for (int k = 0; k < controls.length; ++k) {
                        if (!(controls[k] instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl control = (PagedResultsResponseControl)controls[k];
                        this.cookie = control.getCookie();
                        if (this.cookie == null) {
                            this.end = true;
                        }
                        return;
                    }
                }
                throw ElytronMessages.log.ldapRealmPagedControlNotProvidedByLdapContext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void loadCompleteResult(DirContext context) throws NamingException {
                this.end = true;
                try (NamingEnumeration<SearchResult> result = context.search(LdapSecurityRealm.this.identityMapping.searchDn, LdapSecurityRealm.this.identityMapping.iteratorFilter, LdapSecurityRealm.this.createSearchControls(new String[]{LdapSecurityRealm.this.identityMapping.rdnIdentifier}));){
                    while (result.hasMore()) {
                        SearchResult entry = result.next();
                        String name = (String)entry.getAttributes().get(LdapSecurityRealm.this.identityMapping.rdnIdentifier).get();
                        this.list.add(LdapSecurityRealm.this.getRealmIdentityForUpdate(IdentityLocator.fromName(name)));
                    }
                }
            }

            /*
             * Exception decompiling
             */
            private void loadNextPageOrCompleteResult() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @Override
            public boolean hasNext() {
                return !this.list.isEmpty() || !this.end;
            }

            @Override
            public ModifiableRealmIdentity next() {
                if (this.list.isEmpty()) {
                    if (this.end) {
                        throw new NoSuchElementException();
                    }
                    this.loadNextPageOrCompleteResult();
                }
                ModifiableRealmIdentity identity = this.list.get(0);
                this.list.remove(0);
                return identity;
            }
        };
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"credentialType", credentialType);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        for (CredentialLoader loader : this.credentialLoaders) {
            SupportLevel support = loader.getCredentialAcquireSupport(credentialType, algorithmName);
            if (support.isDefinitelySupported()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        return response;
    }

    @Override
    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        Assert.checkNotNullParam((String)"evidenceType", evidenceType);
        SupportLevel response = SupportLevel.UNSUPPORTED;
        DirContext dirContext = this.obtainContext();
        for (EvidenceVerifier verifier : this.evidenceVerifiers) {
            SupportLevel support = verifier.getEvidenceVerifySupport(dirContext, evidenceType, algorithmName);
            if (support.isDefinitelySupported()) {
                return support;
            }
            if (response.compareTo(support) >= 0) continue;
            response = support;
        }
        this.closeContext(dirContext);
        return response;
    }

    private SearchControls createSearchControls(String ... returningAttributes) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(this.identityMapping.searchRecursive ? 2 : 1);
        searchControls.setTimeLimit(this.identityMapping.searchTimeLimit);
        searchControls.setReturningAttributes(returningAttributes);
        return searchControls;
    }

    private IdentitySharedExclusiveLock getRealmIdentityLockForName(String name) {
        IdentitySharedExclusiveLock newRealmIdentityLock;
        IdentitySharedExclusiveLock realmIdentityLock = this.realmIdentityLocks.get(name);
        if (realmIdentityLock == null && (realmIdentityLock = this.realmIdentityLocks.putIfAbsent(name, newRealmIdentityLock = new IdentitySharedExclusiveLock())) == null) {
            realmIdentityLock = newRealmIdentityLock;
        }
        return realmIdentityLock;
    }

    static class IdentityMapping {
        private final String searchDn;
        private final boolean searchRecursive;
        private final String rdnIdentifier;
        private final List<AttributeMapping> attributes;
        public final int searchTimeLimit;
        private final LdapName newIdentityParent;
        private final javax.naming.directory.Attributes newIdentityAttributes;
        private final String filterName;
        private final String iteratorFilter;

        public IdentityMapping(String searchDn, boolean searchRecursive, int searchTimeLimit, String rdnIdentifier, List<AttributeMapping> attributes, LdapName newIdentityParent, javax.naming.directory.Attributes newIdentityAttributes, String filterName, String iteratorFilter) {
            Assert.checkNotNullParam((String)"rdnIdentifier", (Object)rdnIdentifier);
            this.searchDn = searchDn;
            this.searchRecursive = searchRecursive;
            this.searchTimeLimit = searchTimeLimit;
            this.rdnIdentifier = rdnIdentifier;
            this.attributes = attributes;
            this.newIdentityParent = newIdentityParent;
            this.newIdentityAttributes = newIdentityAttributes;
            this.filterName = filterName;
            this.iteratorFilter = iteratorFilter;
        }
    }

    private class LdapRealmIdentity
    implements ModifiableRealmIdentity {
        private final String name;
        private LdapIdentity identity;
        private IdentitySharedExclusiveLock.IdentityLock lock;

        LdapRealmIdentity(String name, IdentitySharedExclusiveLock.IdentityLock lock) {
            this.name = name;
            this.lock = lock;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            if (!this.exists()) {
                return null;
            }
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return SupportLevel.UNSUPPORTED;
            }
            SupportLevel support = SupportLevel.UNSUPPORTED;
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                if (!loader.getCredentialAcquireSupport(credentialType, algorithmName).mayBeSupported()) continue;
                IdentityCredentialLoader icl = loader.forIdentity(dirContext, this.identity.getDistinguishedName());
                SupportLevel temp = icl.getCredentialAcquireSupport(credentialType, algorithmName, LdapSecurityRealm.this.providers);
                if (temp != null && temp.isDefinitelySupported()) {
                    return temp;
                }
                if (temp == null || support.compareTo(temp) >= 0) continue;
                support = temp;
            }
            LdapSecurityRealm.this.closeContext(dirContext);
            return support;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return this.getCredential(credentialType, null);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            if (!this.exists()) {
                return null;
            }
            if (LdapSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return null;
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            for (CredentialLoader loader : LdapSecurityRealm.this.credentialLoaders) {
                IdentityCredentialLoader icl;
                C credential;
                if (!loader.getCredentialAcquireSupport(credentialType, algorithmName).mayBeSupported() || !credentialType.isInstance(credential = (icl = loader.forIdentity(dirContext, this.identity.getDistinguishedName())).getCredential(credentialType, algorithmName, LdapSecurityRealm.this.providers))) continue;
                return (C)((Credential)credentialType.cast(credential));
            }
            LdapSecurityRealm.this.closeContext(dirContext);
            return null;
        }

        @Override
        public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
            String algorithmName;
            Class<?> credentialType;
            Assert.checkNotNullParam((String)"credentials", credentials);
            if (!this.exists()) {
                throw ElytronMessages.log.ldapRealmIdentityNotExists(this.name);
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            for (Credential credential : credentials) {
                credentialType = credential.getClass();
                algorithmName = credential instanceof AlgorithmCredential ? ((AlgorithmCredential)credential).getAlgorithm() : null;
                boolean supported = false;
                for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                    IdentityCredentialPersister icp = persister.forIdentity(dirContext, this.identity.getDistinguishedName());
                    if (!icp.getCredentialPersistSupport(credentialType, algorithmName)) continue;
                    supported = true;
                }
                if (supported) continue;
                throw ElytronMessages.log.ldapRealmsPersisterNotSupported();
            }
            for (CredentialPersister credentialPersister : LdapSecurityRealm.this.credentialPersisters) {
                IdentityCredentialPersister icp = credentialPersister.forIdentity(dirContext, this.identity.getDistinguishedName());
                icp.clearCredentials();
            }
            block3: for (Credential credential : credentials) {
                credentialType = credential.getClass();
                algorithmName = credential instanceof AlgorithmCredential ? ((AlgorithmCredential)credential).getAlgorithm() : null;
                for (CredentialPersister persister : LdapSecurityRealm.this.credentialPersisters) {
                    IdentityCredentialPersister icp = persister.forIdentity(dirContext, this.identity.getDistinguishedName());
                    if (!icp.getCredentialPersistSupport(credentialType, algorithmName)) continue;
                    icp.persistCredential(credential);
                    continue block3;
                }
            }
            LdapSecurityRealm.this.closeContext(dirContext);
        }

        @Override
        public void dispose() {
            IdentitySharedExclusiveLock.IdentityLock identityLock = this.lock;
            this.lock = null;
            if (identityLock != null) {
                identityLock.release();
            }
        }

        @Override
        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            if (!this.exists()) {
                return AuthorizationIdentity.EMPTY;
            }
            return AuthorizationIdentity.basicIdentity(this.identity.attributes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            if (!this.exists()) {
                return SupportLevel.UNSUPPORTED;
            }
            SupportLevel response = SupportLevel.UNSUPPORTED;
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                    if (!verifier.getEvidenceVerifySupport(dirContext, evidenceType, algorithmName).mayBeSupported()) continue;
                    IdentityEvidenceVerifier iev = verifier.forIdentity(dirContext, this.identity.getDistinguishedName());
                    SupportLevel support = iev.getEvidenceVerifySupport(evidenceType, algorithmName, LdapSecurityRealm.this.providers);
                    if (support != null && support.isDefinitelySupported()) {
                        SupportLevel supportLevel = support;
                        return supportLevel;
                    }
                    if (support == null || support.compareTo(response) <= 0) continue;
                    response = support;
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            String algorithmName;
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            if (!this.exists()) {
                return false;
            }
            Class<?> evidenceType = evidence.getClass();
            String string = algorithmName = evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null;
            if (LdapSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName) == SupportLevel.UNSUPPORTED) {
                return false;
            }
            DirContext dirContext = LdapSecurityRealm.this.obtainContext();
            try {
                for (EvidenceVerifier verifier : LdapSecurityRealm.this.evidenceVerifiers) {
                    IdentityEvidenceVerifier iev;
                    if (!verifier.getEvidenceVerifySupport(dirContext, evidenceType, algorithmName).mayBeSupported() || !(iev = verifier.forIdentity(dirContext, this.identity.getDistinguishedName())).verifyEvidence(evidence, LdapSecurityRealm.this.providers)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(dirContext);
            }
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            boolean exists;
            if (this.identity == null) {
                this.identity = this.getIdentity();
            }
            boolean bl = exists = this.identity != null;
            if (!exists) {
                ElytronMessages.log.debugf("Principal [%s] does not exists.", this.name);
            }
            return exists;
        }

        private LdapSearch searchIdentityByDn() {
            if (!this.name.regionMatches(true, 0, LdapSecurityRealm.this.identityMapping.rdnIdentifier, 0, LdapSecurityRealm.this.identityMapping.rdnIdentifier.length())) {
                return null;
            }
            try {
                LdapName ldapName = new LdapName(this.name);
                int rdnPosition = ldapName.size() - 1;
                Rdn rdnIdentifier = ldapName.getRdn(rdnPosition);
                if (!rdnIdentifier.getType().equalsIgnoreCase(LdapSecurityRealm.this.identityMapping.rdnIdentifier)) {
                    ElytronMessages.log.tracef("Getting identity [%s] by DN skipped - RDN does not match [%s]", this.name, LdapSecurityRealm.this.identityMapping.rdnIdentifier);
                    return null;
                }
                if (LdapSecurityRealm.this.identityMapping.searchDn != null && !ldapName.startsWith(new LdapName(LdapSecurityRealm.this.identityMapping.searchDn).getRdns())) {
                    ElytronMessages.log.tracef("Getting identity [%s] by DN skipped - DN not in search-dn [%s]", this.name, LdapSecurityRealm.this.identityMapping.searchDn);
                    return null;
                }
                ldapName.remove(rdnPosition);
                return new LdapSearch(ldapName.toString(), LdapSecurityRealm.this.identityMapping.filterName, rdnIdentifier.getValue().toString());
            }
            catch (InvalidNameException e) {
                ElytronMessages.log.tracef(e, "Getting identity [%s] by DN failed - will continue by name", this.name);
                return null;
            }
        }

        /*
         * Loose catch block
         */
        private LdapIdentity getIdentity() throws RealmUnavailableException {
            DirContext context;
            ElytronMessages.log.debugf("Trying to create identity for principal [%s].", this.name);
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedObtainIdentityFromServer(this.name, e);
            }
            try {
                LdapSearch ldapSearch = this.searchIdentityByDn();
                if (ldapSearch == null) {
                    ldapSearch = new LdapSearch(LdapSecurityRealm.this.identityMapping.searchDn, LdapSecurityRealm.this.identityMapping.filterName, this.name);
                }
                ldapSearch.setReturningAttributes((String[])LdapSecurityRealm.this.identityMapping.attributes.stream().map(AttributeMapping::getLdapName).toArray(String[]::new));
                try (Stream<LdapIdentity> identityStream = ldapSearch.search(context).map(result -> {
                    MapAttributes identityAttributes = new MapAttributes();
                    identityAttributes.addAll(this.extractSingleAttributes((SearchResult)result));
                    identityAttributes.addAll(this.extractFilteredAttributes((SearchResult)result, context));
                    return new LdapIdentity(result.getNameInNamespace(), identityAttributes.asReadOnly());
                });){
                    Optional<LdapIdentity> optional = identityStream.findFirst();
                    if (optional.isPresent()) {
                        LdapIdentity identity = optional.get();
                        if (ElytronMessages.log.isDebugEnabled()) {
                            ElytronMessages.log.debugf("Successfully created identity for principal [%s].", this.name);
                            if (identity.attributes.isEmpty()) {
                                ElytronMessages.log.debugf("Identity [%s] does not have any attributes.", this.name);
                            } else {
                                ElytronMessages.log.debugf("Identity [%s] attributes are:", this.name);
                                identity.attributes.keySet().forEach(key -> {
                                    Attributes.Entry values = identity.attributes.get((String)key);
                                    values.forEach(value -> ElytronMessages.log.debugf("    Attribute [%s] value [%s].", key, value));
                                });
                            }
                        }
                        LdapIdentity ldapIdentity = identity;
                        return ldapIdentity;
                    }
                    LdapIdentity ldapIdentity = null;
                    return ldapIdentity;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        private Map<String, Collection<String>> extractFilteredAttributes(SearchResult result, DirContext context) {
            String principalDn = result.getNameInNamespace();
            return this.extractAttributes(attribute -> attribute.getFilter() != null, attribute -> {
                ArrayList values = new ArrayList();
                String searchDn = attribute.getSearchDn();
                if (searchDn == null) {
                    searchDn = LdapSecurityRealm.this.identityMapping.searchDn;
                }
                LdapSearch search = new LdapSearch(searchDn, attribute.getFilter(), principalDn);
                search.setReturningAttributes(attribute.getLdapName());
                try (Stream<SearchResult> searchResult = search.search(context);){
                    searchResult.forEach(entry -> {
                        String valueRdn = attribute.getRdn();
                        if (valueRdn != null) {
                            String entryDn = entry.getNameInNamespace();
                            try {
                                for (Rdn rdn : new LdapName(entryDn).getRdns()) {
                                    if (!rdn.getType().equalsIgnoreCase(valueRdn)) continue;
                                    values.add(rdn.getValue().toString());
                                }
                            }
                            catch (Exception cause) {
                                throw ElytronMessages.log.ldapRealmInvalidRdnForAttribute(attribute.getName(), entryDn, valueRdn);
                            }
                        } else {
                            javax.naming.directory.Attributes entryAttributes = entry.getAttributes();
                            Attribute ldapAttribute = entryAttributes.get(attribute.getLdapName());
                            NamingEnumeration<?> attributeValues = null;
                            try {
                                if (ldapAttribute != null) {
                                    attributeValues = ldapAttribute.getAll();
                                    while (attributeValues.hasMore()) {
                                        values.add(attributeValues.next().toString());
                                    }
                                }
                            }
                            catch (Exception cause) {
                                throw ElytronMessages.log.ldapRealmFailedObtainAttributes(principalDn, cause);
                            }
                            finally {
                                if (attributeValues != null) {
                                    try {
                                        attributeValues.close();
                                    }
                                    catch (NamingException namingException) {}
                                }
                            }
                        }
                    });
                }
                catch (Exception cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(principalDn, cause);
                }
                return values;
            });
        }

        private Map<String, Collection<String>> extractSingleAttributes(SearchResult searchResult) {
            return this.extractAttributes(attribute -> attribute.getFilter() == null, attribute -> {
                javax.naming.directory.Attributes returnedAttributes = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> attributesEnum = returnedAttributes.getAll();
                ArrayList<String> values = new ArrayList<String>();
                try {
                    NamingEnumeration<?> attributeValues;
                    while (attributesEnum.hasMore()) {
                        Attribute ldapAttribute = attributesEnum.next();
                        if (!ldapAttribute.getID().equalsIgnoreCase(attribute.getLdapName())) continue;
                        attributeValues = ldapAttribute.getAll();
                        while (attributeValues.hasMore()) {
                            String value = attributeValues.next().toString();
                            String valueRdn = attribute.getRdn();
                            if (valueRdn != null) {
                                try {
                                    for (Rdn rdn : new LdapName(value).getRdns()) {
                                        if (!rdn.getType().equalsIgnoreCase(valueRdn)) continue;
                                        value = rdn.getValue().toString();
                                        break;
                                    }
                                }
                                catch (Exception cause) {
                                    throw ElytronMessages.log.ldapRealmInvalidRdnForAttribute(attribute.getName(), value, valueRdn);
                                }
                            }
                            values.add(value);
                        }
                        if (attributeValues == null) continue;
                        try {
                            attributeValues.close();
                        }
                        catch (NamingException namingException) {
                        }
                    }
                    return values;
                    {
                        catch (Throwable throwable) {
                            if (attributeValues == null) throw throwable;
                            try {
                                attributeValues.close();
                                throw throwable;
                            }
                            catch (NamingException namingException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                catch (NamingException cause) {
                    throw ElytronMessages.log.ldapRealmFailedObtainAttributes(searchResult.getNameInNamespace(), cause);
                }
            });
        }

        private Map<String, Collection<String>> extractAttributes(Predicate<AttributeMapping> filter, Function<AttributeMapping, Collection<String>> valueFunction) {
            return LdapSecurityRealm.this.identityMapping.attributes.stream().filter(filter).collect(Collectors.toMap(AttributeMapping::getName, valueFunction, (m1, m2) -> {
                ArrayList merged = new ArrayList(m1);
                merged.addAll(m2);
                return merged;
            }));
        }

        @Override
        public void delete() throws RealmUnavailableException {
            DirContext context;
            if (this.identity == null) {
                this.identity = this.getIdentity();
            }
            if (this.identity == null) {
                throw ElytronMessages.log.noSuchIdentity();
            }
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedDeleteIdentityFromServer(e);
            }
            try {
                ElytronMessages.log.debugf("Removing identity [%s] with DN [%s] from LDAP", this.name, this.identity.getDistinguishedName());
                context.destroySubcontext(new LdapName(this.identity.getDistinguishedName()));
                this.identity = null;
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedDeleteIdentityFromServer(e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        @Override
        public void create() throws RealmUnavailableException {
            if (LdapSecurityRealm.this.identityMapping.newIdentityParent == null || LdapSecurityRealm.this.identityMapping.newIdentityAttributes == null) {
                throw ElytronMessages.log.ldapRealmNotConfiguredToSupportCreatingIdentities();
            }
            DirContext context = null;
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedCreateIdentityOnServer(e);
            }
            try {
                LdapName distinguishName = (LdapName)LdapSecurityRealm.this.identityMapping.newIdentityParent.clone();
                distinguishName.add(new Rdn(LdapSecurityRealm.this.identityMapping.rdnIdentifier, this.name));
                ElytronMessages.log.debugf("Creating identity [%s] with DN [%s] in LDAP", this.name, distinguishName.toString());
                context.createSubcontext(distinguishName, LdapSecurityRealm.this.identityMapping.newIdentityAttributes);
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmFailedCreateIdentityOnServer(e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            ElytronMessages.log.debugf("Trying to set attributes for principal [%s].", this.name);
            if (this.identity == null) {
                this.identity = this.getIdentity();
            }
            if (this.identity == null) {
                throw ElytronMessages.log.noSuchIdentity();
            }
            DirContext context = null;
            try {
                context = (DirContext)LdapSecurityRealm.this.dirContextSupplier.get();
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmAttributesSettingFailed(this.name, e);
            }
            try {
                LinkedList<ModificationItem> modItems = new LinkedList<ModificationItem>();
                LdapName identityLdapName = new LdapName(this.identity.getDistinguishedName());
                String renameTo = null;
                for (AttributeMapping mapping : LdapSecurityRealm.this.identityMapping.attributes) {
                    BasicAttribute attribute;
                    if (mapping.getFilter() != null || mapping.getRdn() != null) {
                        if (attributes.size(mapping.getName()) == 0) continue;
                        ElytronMessages.log.ldapRealmDoesNotSupportSettingFilteredAttribute(mapping.getName(), this.name);
                        continue;
                    }
                    if (LdapSecurityRealm.this.identityMapping.rdnIdentifier.equalsIgnoreCase(mapping.getLdapName())) {
                        if (attributes.size(mapping.getName()) == 1) {
                            renameTo = attributes.get(mapping.getName(), 0);
                            continue;
                        }
                        throw ElytronMessages.log.ldapRealmRequiresExactlyOneRdnAttribute(mapping.getName(), this.name);
                    }
                    if (attributes.size(mapping.getName()) == 0) {
                        attribute = new BasicAttribute(mapping.getLdapName());
                        modItems.add(new ModificationItem(3, attribute));
                        continue;
                    }
                    attribute = new BasicAttribute(mapping.getLdapName());
                    attributes.get(mapping.getName()).forEach(entryItem -> attribute.add(entryItem));
                    modItems.add(new ModificationItem(2, attribute));
                }
                for (Attributes.Entry entry : attributes.entries()) {
                    if (LdapSecurityRealm.this.identityMapping.attributes.stream().filter(mp -> mp.getName().equals(entry.getKey())).count() != 0L) continue;
                    throw ElytronMessages.log.ldapRealmCannotSetAttributeWithoutMapping(entry.getKey(), this.name);
                }
                ModificationItem[] modItemsArray = modItems.toArray(new ModificationItem[modItems.size()]);
                context.modifyAttributes(identityLdapName, modItemsArray);
                if (renameTo != null && !renameTo.equals((String)identityLdapName.getRdn(identityLdapName.size() - 1).getValue())) {
                    LdapName newLdapName = new LdapName(identityLdapName.getRdns().subList(0, identityLdapName.size() - 1));
                    newLdapName.add(new Rdn(LdapSecurityRealm.this.identityMapping.rdnIdentifier, renameTo));
                    context.rename(identityLdapName, newLdapName);
                }
            }
            catch (Exception e) {
                throw ElytronMessages.log.ldapRealmAttributesSettingFailed(this.name, e);
            }
            finally {
                LdapSecurityRealm.this.closeContext(context);
            }
        }

        @Override
        public Attributes getAttributes() throws RealmUnavailableException {
            if (this.identity == null) {
                this.identity = this.getIdentity();
            }
            if (this.identity == null) {
                throw ElytronMessages.log.noSuchIdentity();
            }
            return this.identity.getAttributes().asReadOnly();
        }

        private class LdapSearch {
            private final String[] filterArgs;
            private final String searchDn;
            private final String filter;
            private String[] returningAttributes;

            public LdapSearch(String searchDn, String filter, String ... filterArgs) {
                this.searchDn = searchDn;
                this.filter = filter;
                this.filterArgs = filterArgs;
            }

            public Stream<SearchResult> search(DirContext context) throws RealmUnavailableException {
                ElytronMessages.log.debugf("Executing search [%s] in context [%s] with arguments [%s]. Returning attributes are [%s]", new Object[]{this.filter, this.searchDn, this.filterArgs, this.returningAttributes});
                try {
                    final NamingEnumeration<SearchResult> result = context.search(this.searchDn, this.filter, (Object[])this.filterArgs, LdapSecurityRealm.this.createSearchControls(this.returningAttributes));
                    return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<SearchResult>(Long.MAX_VALUE, 256){

                        @Override
                        public boolean tryAdvance(Consumer<? super SearchResult> action) {
                            try {
                                if (!result.hasMore()) {
                                    return false;
                                }
                                SearchResult entry = (SearchResult)result.next();
                                ElytronMessages.log.debugf("Found entry [%s].", entry.getNameInNamespace());
                                action.accept(entry);
                                return true;
                            }
                            catch (NamingException e) {
                                throw ElytronMessages.log.ldapRealmErrorWhileConsumingResultsFromSearch(LdapSearch.this.searchDn, LdapSearch.this.filter, Arrays.toString(LdapSearch.this.filterArgs), e);
                            }
                        }
                    }, false).onClose(() -> {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (NamingException namingException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw ElytronMessages.log.ldapRealmIdentitySearchFailed(e);
                }
            }

            public void setReturningAttributes(String ... returningAttributes) {
                this.returningAttributes = returningAttributes;
            }
        }

        private class LdapIdentity {
            private final String distinguishedName;
            private final Attributes attributes;

            LdapIdentity(String distinguishedName, Attributes attributes) {
                this.distinguishedName = distinguishedName;
                this.attributes = attributes;
            }

            String getDistinguishedName() {
                return this.distinguishedName;
            }

            Attributes getAttributes() {
                return this.attributes;
            }
        }
    }
}

