/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.permission.ChangeRoleMapperPermission;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.RealmInfo;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.PermissionMappable;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.permission.ElytronPermission;
import org.wildfly.security.permission.PermissionVerifier;

public final class SecurityIdentity
implements PermissionVerifier,
PermissionMappable {
    private static final Permission SET_RUN_AS_PERMISSION = ElytronPermission.forName("setRunAsPrincipal");
    private static final Permission PRIVATE_CREDENTIALS_PERMISSION = ElytronPermission.forName("getPrivateCredentials");
    private final SecurityDomain securityDomain;
    private final Principal principal;
    private final AuthorizationIdentity authorizationIdentity;
    private final RealmInfo realmInfo;
    private final Map<String, RoleMapper> roleMappers;
    private final Instant creationTime;
    private final PermissionVerifier verifier;
    private final IdentityCredentials publicCredentials;
    private final IdentityCredentials privateCredentials;

    SecurityIdentity(SecurityDomain securityDomain, Principal principal, RealmInfo realmInfo, AuthorizationIdentity authorizationIdentity, Map<String, RoleMapper> roleMappers, IdentityCredentials publicCredentials, IdentityCredentials privateCredentials) {
        this.securityDomain = securityDomain;
        this.principal = principal;
        this.realmInfo = realmInfo;
        this.authorizationIdentity = authorizationIdentity;
        this.roleMappers = roleMappers;
        this.creationTime = Instant.now();
        this.verifier = securityDomain.mapPermissions(this);
        this.publicCredentials = publicCredentials;
        this.privateCredentials = privateCredentials;
    }

    SecurityIdentity(SecurityIdentity old, Map<String, RoleMapper> roleMappers) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
        this.publicCredentials = old.publicCredentials;
        this.privateCredentials = old.privateCredentials;
    }

    SecurityIdentity(SecurityIdentity old, PermissionVerifier verifier) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = verifier;
        this.publicCredentials = old.publicCredentials;
        this.privateCredentials = old.privateCredentials;
    }

    SecurityIdentity(SecurityIdentity old, Credential credential, boolean isPrivate) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
        this.publicCredentials = isPrivate ? old.publicCredentials : old.publicCredentials.withCredential(credential);
        this.privateCredentials = isPrivate ? old.privateCredentials.withCredential(credential) : old.privateCredentials;
    }

    SecurityIdentity(SecurityIdentity old, IdentityCredentials credentials, boolean isPrivate) {
        this.securityDomain = old.securityDomain;
        this.principal = old.principal;
        this.realmInfo = old.realmInfo;
        this.authorizationIdentity = old.authorizationIdentity;
        this.roleMappers = old.roleMappers;
        this.creationTime = old.creationTime;
        this.verifier = old.verifier;
        this.publicCredentials = isPrivate ? old.publicCredentials : old.publicCredentials.with(credentials);
        this.privateCredentials = isPrivate ? old.privateCredentials.with(credentials) : old.privateCredentials;
    }

    SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    RealmInfo getRealmInfo() {
        return this.realmInfo;
    }

    AuthorizationIdentity getAuthorizationIdentity() {
        return this.authorizationIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAs(Runnable action) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.run();
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(Callable<T> action) throws Exception {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.call();
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAs(PrivilegedAction<T> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run();
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T> T runAs(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run();
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T runAs(P parameter, ParametricPrivilegedAction<T, P> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T, P> T runAs(P parameter, ParametricPrivilegedExceptionAction<T, P> action) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.run(parameter);
            return t;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T, R> R runAsFunction(Function<T, R> action, T parameter) {
        if (action == null) {
            return null;
        }
        return (R)this.runAsFunction(Function::apply, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U, R> R runAsFunction(BiFunction<T, U, R> action, T parameter1, U parameter2) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            R r = action.apply(parameter1, parameter2);
            return r;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public <T> void runAsConsumer(Consumer<T> action, T parameter) {
        if (action == null) {
            return;
        }
        this.runAsConsumer(Consumer::accept, action, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U> void runAsConsumer(BiConsumer<T, U> action, T parameter1, U parameter2) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void runAsObjIntConsumer(ObjIntConsumer<T> action, T parameter1, int parameter2) {
        if (action == null) {
            return;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            action.accept(parameter1, parameter2);
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAsSupplier(Supplier<T> action) {
        if (action == null) {
            return null;
        }
        SecurityDomain securityDomain = this.securityDomain;
        SecurityIdentity old = securityDomain.getAndSetCurrentSecurityIdentity(this);
        try {
            T t = action.get();
            return t;
        }
        finally {
            securityDomain.setCurrentSecurityIdentity(old);
        }
    }

    public static <T> T runAsAll(PrivilegedExceptionAction<T> action, SecurityIdentity ... identities) throws PrivilegedActionException {
        if (action == null) {
            return null;
        }
        int length = identities.length;
        SecurityIdentity[] oldIdentities = new SecurityIdentity[length];
        for (int i = 0; i < length; ++i) {
            SecurityIdentity securityIdentity = identities[i];
            SecurityDomain securityDomain = securityIdentity.getSecurityDomain();
            oldIdentities[i] = securityDomain.getAndSetCurrentSecurityIdentity(securityIdentity);
        }
        try {
            T i = action.run();
            return i;
        }
        catch (RuntimeException | PrivilegedActionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            for (int i = 0; i < length; ++i) {
                SecurityIdentity oldIdentity = oldIdentities[i];
                SecurityDomain securityDomain = oldIdentity.getSecurityDomain();
                securityDomain.setCurrentSecurityIdentity(oldIdentity);
            }
        }
    }

    public Roles getRoles() {
        return this.securityDomain.mapRoles(this);
    }

    public Roles getRoles(String category) {
        return this.getRoles(category, false);
    }

    public Roles getRoles(String category, boolean fallbackToDefault) {
        RoleMapper roleMapper = this.roleMappers.get(category);
        return roleMapper == null ? (fallbackToDefault ? this.getRoles() : Roles.NONE) : roleMapper.mapRoles(this.securityDomain.mapRoles(this));
    }

    public SecurityIdentity withRoleMapper(String category, RoleMapper roleMapper) {
        Map<String, RoleMapper> newMap;
        Assert.checkNotNullParam((String)"category", (Object)category);
        Assert.checkNotNullParam((String)"roleMapper", (Object)roleMapper);
        Map<String, RoleMapper> roleMappers = this.roleMappers;
        RoleMapper existingRoleMapper = roleMappers.get(category);
        if (existingRoleMapper == roleMapper) {
            return this;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ChangeRoleMapperPermission(category));
        }
        if (roleMappers.isEmpty() || roleMappers.size() == 1 && roleMappers.keySet().iterator().next().equals(category)) {
            newMap = Collections.singletonMap(category, roleMapper);
        } else {
            newMap = new HashMap<String, RoleMapper>(roleMappers);
            newMap.put(category, roleMapper);
        }
        return new SecurityIdentity(this, newMap);
    }

    public SecurityIdentity createRunAsIdentity(String name) throws SecurityException {
        return this.createRunAsIdentity(name, true);
    }

    public SecurityIdentity createRunAsIdentity(String name, boolean authorize) throws SecurityException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_RUN_AS_PERMISSION);
        }
        ServerAuthenticationContext context = this.securityDomain.createNewAuthenticationContext(this, MechanismConfigurationSelector.constantSelector(MechanismConfiguration.EMPTY));
        try {
            if (!context.importIdentity(this) || !context.authorize(name, authorize)) {
                throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, new NamePrincipal(name), null);
            }
        }
        catch (RealmUnavailableException e) {
            throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, context.getAuthenticationPrincipal(), e);
        }
        return context.getAuthorizedIdentity();
    }

    public SecurityIdentity createRunAsAnonymous() throws SecurityException {
        return this.createRunAsAnonymous(true);
    }

    public SecurityIdentity createRunAsAnonymous(boolean authorize) throws SecurityException {
        ServerAuthenticationContext context;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_RUN_AS_PERMISSION);
        }
        if (!(context = this.securityDomain.createNewAuthenticationContext(this, MechanismConfigurationSelector.constantSelector(MechanismConfiguration.EMPTY))).authorizeAnonymous(false)) {
            throw ElytronMessages.log.runAsAuthorizationFailed(this.principal, AnonymousPrincipal.getInstance(), null);
        }
        return context.getAuthorizedIdentity();
    }

    public SecurityIdentity intersectWith(PermissionVerifier verifier) {
        Assert.checkNotNullParam((String)"verifier", (Object)verifier);
        return new SecurityIdentity(this, this.verifier.and(verifier));
    }

    @Override
    public boolean implies(Permission permission) {
        return this.verifier.implies(permission);
    }

    @Override
    public Attributes getAttributes() {
        return this.authorizationIdentity.getAttributes().asReadOnly();
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public IdentityCredentials getPublicCredentials() {
        return this.publicCredentials;
    }

    public boolean isAnonymous() {
        return this.principal instanceof AnonymousPrincipal;
    }

    public SecurityIdentity withPublicCredential(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return new SecurityIdentity(this, credential, false);
    }

    public SecurityIdentity withPublicCredentials(IdentityCredentials credentials) {
        Assert.checkNotNullParam((String)"credentials", (Object)credentials);
        return credentials == IdentityCredentials.NONE ? this : new SecurityIdentity(this, credentials, false);
    }

    public SecurityIdentity withPrivateCredential(Credential credential) {
        Assert.checkNotNullParam((String)"credential", (Object)credential);
        return new SecurityIdentity(this, credential, true);
    }

    public SecurityIdentity withPrivateCredentials(IdentityCredentials credentials) {
        Assert.checkNotNullParam((String)"credentials", (Object)credentials);
        return credentials == IdentityCredentials.NONE ? this : new SecurityIdentity(this, credentials, true);
    }

    public IdentityCredentials getPrivateCredentials() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PRIVATE_CREDENTIALS_PERMISSION);
        }
        return this.getPrivateCredentialsPrivate();
    }

    IdentityCredentials getPrivateCredentialsPrivate() {
        return this.privateCredentials;
    }
}

