/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.uri.AbstractCFSchema;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.uri.TCPServerLocatorSchema;
import org.apache.activemq.artemis.uri.TCPTransportConfigurationSchema;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class TCPSchema
extends AbstractCFSchema {
    @Override
    public String getSchemaName() {
        return "tcp";
    }

    @Override
    protected ActiveMQConnectionFactory internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        JMSConnectionOptions options = this.newConectionOptions(uri, query);
        List<TransportConfiguration> configurations = TCPTransportConfigurationSchema.getTransportConfigurations(uri, query, TransportConstants.ALLOWABLE_CONNECTOR_KEYS, name, NettyConnectorFactory.class.getName());
        TransportConfiguration[] tcs = new TransportConfiguration[configurations.size()];
        configurations.toArray(tcs);
        ActiveMQConnectionFactory factory = options.isHa() ? ActiveMQJMSClient.createConnectionFactoryWithHA(options.getFactoryTypeEnum(), tcs) : ActiveMQJMSClient.createConnectionFactoryWithoutHA(options.getFactoryTypeEnum(), tcs);
        return URISchema.setData(uri, factory, query);
    }

    @Override
    protected URI internalNewURI(ActiveMQConnectionFactory bean) throws Exception {
        String query = URISchema.getData(null, bean);
        TransportConfiguration[] staticConnectors = bean.getStaticConnectors();
        return TCPServerLocatorSchema.getURI(query, staticConnectors);
    }
}

