/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SubscribeClusterTopologyUpdatesMessage
extends PacketImpl {
    private boolean clusterConnection;

    public SubscribeClusterTopologyUpdatesMessage(boolean clusterConnection) {
        super((byte)112);
        this.clusterConnection = clusterConnection;
    }

    protected SubscribeClusterTopologyUpdatesMessage(byte packetType, boolean clusterConnection) {
        super(packetType);
        this.clusterConnection = clusterConnection;
    }

    public SubscribeClusterTopologyUpdatesMessage() {
        super((byte)112);
    }

    protected SubscribeClusterTopologyUpdatesMessage(byte packetType) {
        super(packetType);
    }

    public boolean isClusterConnection() {
        return this.clusterConnection;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.clusterConnection);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.clusterConnection = buffer.readBoolean();
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", clusterConnection=" + this.clusterConnection);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.clusterConnection ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SubscribeClusterTopologyUpdatesMessage)) {
            return false;
        }
        SubscribeClusterTopologyUpdatesMessage other = (SubscribeClusterTopologyUpdatesMessage)obj;
        return this.clusterConnection == other.clusterConnection;
    }
}

