/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

public final class SubstringFilterSpec
extends FilterSpec {
    private final String attribute;
    private final String initialPart;
    private final String finalPart;

    SubstringFilterSpec(String attribute, String initialPart, String finalPart) {
        this.attribute = attribute;
        this.initialPart = initialPart;
        this.finalPart = finalPart;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        String value = attributes.get(this.attribute).toString();
        return value.startsWith(this.initialPart) && value.endsWith(this.finalPart);
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        Collection<AttributeValue> collection = attributes.get(this.attribute);
        if (collection != null) {
            for (AttributeValue matchValue : collection) {
                String value = matchValue.toString();
                if (!value.startsWith(this.initialPart) || !value.endsWith(this.finalPart)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mayMatch(Collection<String> attributeNames) {
        return attributeNames.contains(this.attribute);
    }

    @Override
    public boolean mayNotMatch(Collection<String> attributeNames) {
        return true;
    }

    @Override
    public <P, R, E extends Exception> R accept(FilterSpec.Visitor<P, R, E> visitor, P parameter) throws E {
        return visitor.handle(this, parameter);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getInitialPart() {
        return this.initialPart;
    }

    public String getFinalPart() {
        return this.finalPart;
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(');
        FilterSpec.escapeTo(this.attribute, builder);
        builder.append('=');
        FilterSpec.escapeTo(this.initialPart, builder);
        builder.append('*');
        FilterSpec.escapeTo(this.finalPart, builder);
        builder.append(')');
    }
}

