/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.AttributeValueTranslator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class ListAttributeTranslation
implements AttributeTranslation {
    private static final AttributeValueTranslator READ_TRANSLATOR = new AttributeValueTranslator(){

        @Override
        public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
            return value.isDefined() ? (ModelNode)value.asList().get(0) : value;
        }
    };
    private static final AttributeValueTranslator WRITE_TRANSLATOR = new AttributeValueTranslator(){

        @Override
        public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
            return new ModelNode().add(value);
        }
    };
    private final Attribute targetAttribute;

    public ListAttributeTranslation(Attribute targetAttribute) {
        this.targetAttribute = targetAttribute;
    }

    @Override
    public Attribute getTargetAttribute() {
        return this.targetAttribute;
    }

    @Override
    public AttributeValueTranslator getReadTranslator() {
        return READ_TRANSLATOR;
    }

    @Override
    public AttributeValueTranslator getWriteTranslator() {
        return WRITE_TRANSLATOR;
    }
}

