/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.wildfly.clustering.infinispan.marshalling.AbstractMarshaller;
import org.wildfly.clustering.infinispan.marshalling.protostream.IOSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;

public class ProtoStreamMarshaller
extends AbstractMarshaller {
    private final ProtoStreamByteBufferMarshaller marshaller;

    public ProtoStreamMarshaller(ClassLoaderMarshaller loaderMarshaller, ClassLoader loader) {
        this(new SerializationContextBuilder(loaderMarshaller).require(loader));
    }

    protected ProtoStreamMarshaller(SerializationContextBuilder builder) {
        this(builder.register((SerializationContextInitializer)new IOSerializationContextInitializer()).build());
    }

    public ProtoStreamMarshaller(ImmutableSerializationContext context) {
        this.marshaller = new ProtoStreamByteBufferMarshaller(context);
    }

    @Override
    public int sizeEstimate(Object object) {
        return this.marshaller.size(object).orElse(512);
    }

    public boolean isMarshallable(Object object) {
        return this.marshaller.isMarshallable(object);
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_PROTOSTREAM;
    }

    public void writeObject(Object object, OutputStream output) throws IOException {
        this.marshaller.writeTo(output, object);
    }

    public Object readObject(InputStream input) throws IOException {
        return this.marshaller.readFrom(input);
    }
}

