/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.Map;
import java.util.function.Function;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocatorConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;

public class PrimaryOwnerRouteLocator
implements RouteLocator {
    private final Function<GroupedKey<String>, Node> primaryOwnerLocator;
    private final Registry<String, Void> registry;
    private final boolean preferPrimary;
    private final String localRoute;

    public PrimaryOwnerRouteLocator(PrimaryOwnerRouteLocatorConfiguration config) {
        this.registry = config.getRegistry();
        this.primaryOwnerLocator = new PrimaryOwnerLocator(config.getCache(), config.getMemberFactory(), this.registry.getGroup());
        this.preferPrimary = config.getCache().getCacheConfiguration().clustering().cacheMode().isClustered();
        this.localRoute = (String)this.registry.getEntry(this.registry.getGroup().getLocalMember()).getKey();
    }

    public String locate(String sessionId) {
        Node primaryMember = this.preferPrimary ? this.primaryOwnerLocator.apply((GroupedKey<String>)new GroupedKey((Object)sessionId)) : null;
        Map.Entry entry = primaryMember != null ? this.registry.getEntry(primaryMember) : null;
        return entry != null ? (String)entry.getKey() : this.localRoute;
    }
}

