/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.statistics;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.dynamicresource.StatisticsResourceDefinition;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.management.AdminObject;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class AdminObjectStatisticsService
implements Service<ManagementResourceRegistration> {
    private final ManagementResourceRegistration overrideRegistration;
    private final boolean statsEnabled;
    protected final InjectedValue<ResourceAdapterDeployment> deployment = new InjectedValue();
    protected final InjectedValue<CloneableBootstrapContext> bootstrapContext = new InjectedValue();

    public AdminObjectStatisticsService(ManagementResourceRegistration registration, String jndiName, boolean statsEnabled) {
        this.overrideRegistration = registration.isAllowsOverride() ? registration.registerOverrideModel(jndiName, new OverrideDescriptionProvider(){

            public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }

            public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }
        }) : registration;
        this.statsEnabled = statsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("Starting ResourceAdapterStatusicService", new Object[0]);
        AdminObjectStatisticsService adminObjectStatisticsService = this;
        synchronized (adminObjectStatisticsService) {
            CommonDeployment deploymentMD = ((ResourceAdapterDeployment)this.deployment.getValue()).getDeployment();
            PathElement peExtendedStats = PathElement.pathElement((String)"statistics", (String)"extended");
            if (deploymentMD.getConnector() != null && deploymentMD.getConnector().getAdminObjects() != null) {
                for (AdminObject ao : deploymentMD.getConnector().getAdminObjects()) {
                    if (ao.getStatistics() == null) continue;
                    StatisticsPlugin extendStats = ao.getStatistics();
                    extendStats.setEnabled(this.statsEnabled);
                    if (extendStats.getNames().size() == 0 || extendStats.getNames().size() == 0 || this.overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peExtendedStats})) != null) continue;
                    this.overrideRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(peExtendedStats, CommonAttributes.RESOURCE_NAME, extendStats));
                }
            }
        }
    }

    public void stop(StopContext context) {
        PathElement peLocaldWm = PathElement.pathElement((String)"statistics", (String)"extended");
        if (this.overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peLocaldWm})) != null) {
            this.overrideRegistration.unregisterSubModel(peLocaldWm);
        }
    }

    public ManagementResourceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Injector<ResourceAdapterDeployment> getResourceAdapterDeploymentInjector() {
        return this.deployment;
    }

    public Injector<CloneableBootstrapContext> getBootstrapContextInjector() {
        return this.bootstrapContext;
    }
}

