/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.activemq.artemis.wildfly.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.jboss.activemq.artemis.wildfly.ActiveMQJBossLogger;
import org.jboss.activemq.artemis.wildfly.security.AS4SecurityActions;
import org.jboss.activemq.artemis.wildfly.security.SecurityActions;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimplePrincipal;

public class JBossASSecurityManager
implements ActiveMQSecurityManager,
ActiveMQComponent {
    private final boolean trace = ActiveMQJBossLogger.LOGGER.isTraceEnabled();
    private RealmMapping realmMapping;
    private AuthenticationManager authenticationManager;
    private String securityDomainName = "java:/jaas/activemq";
    private boolean started;
    private boolean isAs5 = true;
    private boolean allowClientLogin = false;
    private boolean authoriseOnClientLogin = false;

    public boolean validateUser(String user, String password) {
        SimplePrincipal principal = new SimplePrincipal(user);
        char[] passwordChars = null;
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        Subject subject = new Subject();
        return this.authenticationManager.isValid((Principal)principal, (Object)passwordChars, subject);
    }

    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        if (this.allowClientLogin && SecurityContextAssociation.isClient()) {
            return this.authoriseOnClientLogin ? this.useClientAuthentication(roles, checkType) : true;
        }
        return this.useConnectionAuthentication(user, password, roles, checkType);
    }

    private boolean useConnectionAuthentication(final String user, final String password, final Set<Role> roles, final CheckType checkType) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                SimplePrincipal principal = user == null ? null : new SimplePrincipal(user);
                char[] passwordChars = null;
                if (password != null) {
                    passwordChars = password.toCharArray();
                }
                Subject subject = new Subject();
                boolean authenticated = JBossASSecurityManager.this.authenticationManager.isValid((Principal)principal, (Object)passwordChars, subject);
                if (authenticated) {
                    JBossASSecurityManager.this.pushSecurityContext(principal, passwordChars, subject);
                    Set rolePrincipals = JBossASSecurityManager.this.getRolePrincipals(checkType, roles);
                    authenticated = JBossASSecurityManager.this.realmMapping.doesUserHaveRole((Principal)principal, rolePrincipals);
                    if (JBossASSecurityManager.this.trace) {
                        ActiveMQJBossLogger.LOGGER.trace("user " + user + (authenticated ? " is " : " is NOT ") + "authorized");
                    }
                    JBossASSecurityManager.this.popSecurityContext();
                }
                return authenticated;
            }
        });
    }

    private boolean useClientAuthentication(final Set<Role> roles, final CheckType checkType) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                Principal principal = sc.getUtil().getUserPrincipal();
                char[] passwordChars = (char[])sc.getUtil().getCredential();
                Subject subject = sc.getSubjectInfo().getAuthenticatedSubject();
                boolean authenticated = JBossASSecurityManager.this.authenticationManager.isValid(principal, (Object)passwordChars, subject);
                if (authenticated) {
                    Set rolePrincipals = JBossASSecurityManager.this.getRolePrincipals(checkType, roles);
                    authenticated = JBossASSecurityManager.this.realmMapping.doesUserHaveRole(principal, rolePrincipals);
                    if (JBossASSecurityManager.this.trace) {
                        ActiveMQJBossLogger.LOGGER.trace("user " + principal.getName() + (authenticated ? " is " : " is NOT ") + "authorized");
                    }
                }
                return authenticated;
            }
        });
    }

    private void popSecurityContext() {
        if (this.isAs5) {
            SecurityActions.popSubjectContext();
        } else {
            AS4SecurityActions.popSubjectContext();
        }
    }

    private void pushSecurityContext(SimplePrincipal principal, char[] passwordChars, Subject subject) {
        if (this.isAs5) {
            SecurityActions.pushSubjectContext((Principal)principal, passwordChars, subject, this.securityDomainName);
        } else {
            AS4SecurityActions.pushSubjectContext((Principal)principal, passwordChars, subject);
        }
    }

    public void addRole(String user, String role) {
    }

    public void addUser(String user, String password) {
    }

    public void removeRole(String user, String role) {
    }

    public void removeUser(String user) {
    }

    public void setDefaultUser(String username) {
    }

    private Set<Principal> getRolePrincipals(CheckType checkType, Set<Role> roles) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            principals.add((Principal)new SimplePrincipal(role.getName()));
        }
        return principals;
    }

    public void setRealmMapping(RealmMapping realmMapping) {
        this.realmMapping = realmMapping;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        InitialContext ic = new InitialContext();
        this.authenticationManager = (AuthenticationManager)ic.lookup(this.securityDomainName);
        this.realmMapping = (RealmMapping)this.authenticationManager;
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void setSecurityDomainName(String securityDomainName) {
        this.securityDomainName = securityDomainName;
    }

    public void setAs5(boolean as5) {
        this.isAs5 = as5;
    }

    public void setAllowClientLogin(boolean allowClientLogin) {
        this.allowClientLogin = allowClientLogin;
    }

    public void setAuthoriseOnClientLogin(boolean authoriseOnClientLogin) {
        this.authoriseOnClientLogin = authoriseOnClientLogin;
    }
}

