/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.operation;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.ExpressionBaseState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.QuotesState;
import org.jboss.as.cli.parsing.WordCharacterHandler;

public class HeaderValueState
extends ExpressionBaseState {
    public static final HeaderValueState INSTANCE = new HeaderValueState();
    public static final String ID = "HEADER_VALUE";

    HeaderValueState() {
        super(ID);
        this.putHandler(';', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        this.putHandler('}', GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.getCharacter() != '=') {
                    if (ctx.getCharacter() == '\"') {
                        ctx.enterState(QuotesState.QUOTES_EXCLUDED);
                    } else {
                        ctx.getCallbackHandler().character(ctx);
                    }
                }
            }
        });
        this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                char c = ctx.getCharacter();
                if (c == ';' || c == '}') {
                    ctx.leaveState();
                }
            }
        });
        this.setIgnoreWhitespaces(true);
    }

    @Override
    public boolean lockValueIndex() {
        return true;
    }
}

