/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.cli.command.aesh.activator;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.wildfly.core.cli.command.aesh.activator.DependOptionActivator;

public abstract class AbstractDependOptionActivator
implements DependOptionActivator {
    private final Set<String> options;
    private final boolean lax;

    protected AbstractDependOptionActivator(boolean lax, String ... opts) {
        this.options = new HashSet<String>(Arrays.asList(opts));
        this.lax = lax;
    }

    protected AbstractDependOptionActivator(boolean lax, Set<String> opts) {
        this.lax = lax;
        this.options = opts;
    }

    @Override
    public boolean isActivated(ParsedCommand processedCommand) {
        boolean found = true;
        for (String opt : this.options) {
            if ("".equals(opt)) {
                found &= processedCommand.argument() != null && (this.lax || processedCommand.argument().value() != null);
                continue;
            }
            ParsedOption processedOption = processedCommand.findLongOptionNoActivatorCheck(opt);
            found &= processedOption != null && (this.lax || processedOption.value() != null);
        }
        return found;
    }

    @Override
    public Set<String> getDependsOn() {
        return Collections.unmodifiableSet(this.options);
    }
}

