/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi;

import com.arjuna.ats.jta.cdi.RunnableWithException;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;

public final class TransactionHandler {
    public static void handleExceptionNoThrow(Transactional transactional, Throwable t, Transaction tx2) throws IllegalStateException, SystemException {
        for (Class dontRollbackOnClass : transactional.dontRollbackOn()) {
            if (!dontRollbackOnClass.isAssignableFrom(t.getClass())) continue;
            return;
        }
        for (Class rollbackOnClass : transactional.rollbackOn()) {
            if (!rollbackOnClass.isAssignableFrom(t.getClass())) continue;
            tx2.setRollbackOnly();
            return;
        }
        if (t instanceof RuntimeException || t instanceof Error) {
            tx2.setRollbackOnly();
            return;
        }
    }

    public static void endTransaction(TransactionManager tm, Transaction tx2, RunnableWithException afterEndTransaction) throws Exception {
        try {
            if (tx2 != tm.getTransaction()) {
                throw new RuntimeException(jtaLogger.i18NLogger.get_wrong_tx_on_thread());
            }
            if (tx2.getStatus() == 1) {
                tm.rollback();
            } else {
                tm.commit();
            }
        }
        finally {
            afterEndTransaction.run();
        }
    }
}

