/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.security.SigningAlgorithm;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.ParameterParser;

public class DKIMSignature {
    public static final String DKIM_SIGNATURE = "DKIM-Signature";
    public static final String TIMESTAMP = "t";
    public static final String DOMAIN = "d";
    public static final String EXPIRATION = "x";
    public static final String ALGORITHM = "a";
    public static final String SIGNATURE = "b";
    public static final String HEADERS = "h";
    public static final String IDENTITY = "i";
    public static final String VERSION = "v";
    public static final String BODY_HASH = "bh";
    public static final String CANONICALIZATION = "c";
    public static final String QUERY = "q";
    public static final String SELECTOR = "s";
    public static final String LENGTH = "l";
    public static String DEFAULT_SIGNER = "DEFAULT_SIGNER";
    public static final String SHA256WITH_RSA = "SHA256withRSA";
    public static String DEFAULT_ALGORITHM = "SHA256withRSA";
    protected PrivateKey privateKey;
    protected Map<String, String> attributes = new LinkedHashMap<String, String>();
    protected List<String> headers = new ArrayList<String>();
    protected byte[] signature;
    protected String headerValue;
    protected boolean bodyHashRequired = true;

    public DKIMSignature() {
    }

    public DKIMSignature(Map<String, String> attrs) {
        this.attributes = attrs;
        this.extractAttributes();
    }

    public DKIMSignature(String headerValue) {
        this.headerValue = headerValue;
        ParameterParser parser = new ParameterParser();
        this.attributes = parser.parse(headerValue, ';');
        this.extractAttributes();
    }

    protected void extractAttributes() {
        String sig;
        String heads = this.attributes.get(HEADERS);
        if (heads != null) {
            this.headers = Arrays.asList(heads.split(":"));
        }
        if ((sig = this.attributes.get(SIGNATURE)) != null) {
            this.signature = Base64.getDecoder().decode(sig);
        }
    }

    public List<String> getHeaderList() {
        return this.headers;
    }

    public String toString() {
        return this.headerValue;
    }

    public boolean isBodyHashRequired() {
        return this.bodyHashRequired;
    }

    public void setBodyHashRequired(boolean bodyHashRequired) {
        this.bodyHashRequired = bodyHashRequired;
    }

    public void addHeader(String headerName) {
        this.headers.add(headerName);
    }

    public void setAttribute(String name, String value) {
        if (value == null) {
            this.attributes.remove(name);
        }
        this.attributes.put(name, value);
    }

    public void setAlgorithm(String value) {
        this.setAttribute(ALGORITHM, value);
    }

    public void setTimestamp(String value) {
        this.setAttribute(TIMESTAMP, value);
    }

    public void setTimestamp() {
        this.setAttribute(TIMESTAMP, new Date().getTime() / 1000L + "");
    }

    public void setSelector(String selector) {
        this.setAttribute(SELECTOR, selector);
    }

    public String getSelector() {
        return this.attributes.get(SELECTOR);
    }

    public String getQuery() {
        return this.attributes.get(QUERY);
    }

    public void setQuery(String query) {
        this.setAttribute(QUERY, query);
    }

    public void setDomain(String domain) {
        this.setAttribute(DOMAIN, domain);
    }

    public String getDomain() {
        return this.attributes.get(DOMAIN);
    }

    public void setId(String id) {
        this.setAttribute(IDENTITY, id);
    }

    public void setExpiration(Date expire) {
        this.setAttribute(EXPIRATION, expire.getTime() / 1000L + "");
    }

    public void setExpiration(int seconds, int minutes, int hours, int days, int months, int years) {
        Calendar now = Calendar.getInstance();
        if (seconds > 0) {
            now.add(13, seconds);
        }
        if (minutes > 0) {
            now.add(12, minutes);
        }
        if (hours > 0) {
            now.add(10, hours);
        }
        if (days > 0) {
            now.add(5, days);
        }
        if (months > 0) {
            now.add(2, months);
        }
        if (years > 0) {
            now.add(1, years);
        }
        this.setExpiration(now.getTime());
    }

    public boolean isExpired() {
        String exp = this.attributes.get(EXPIRATION);
        if (exp == null) {
            return false;
        }
        long expL = Long.parseLong(exp);
        return expL * 1000L < new Date().getTime();
    }

    public boolean isStale(int seconds, int minutes, int hours, int days, int months, int years) {
        String time = this.attributes.get(TIMESTAMP);
        if (time == null) {
            return true;
        }
        long timeL = Long.parseLong(time);
        Date timestamp = new Date(timeL * 1000L);
        Calendar expires = Calendar.getInstance();
        expires.setTime(timestamp);
        if (seconds > 0) {
            expires.add(13, seconds);
        }
        if (minutes > 0) {
            expires.add(12, minutes);
        }
        if (hours > 0) {
            expires.add(10, hours);
        }
        if (days > 0) {
            expires.add(5, days);
        }
        if (months > 0) {
            expires.add(2, months);
        }
        if (years > 0) {
            expires.add(1, years);
        }
        return new Date().getTime() > expires.getTime().getTime();
    }

    public String getId() {
        return this.attributes.get(IDENTITY);
    }

    public String getAlgorithm() {
        return this.attributes.get(ALGORITHM);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getBased64Signature() {
        return this.attributes.get(SIGNATURE);
    }

    public void setBase64Signature(String signature) {
        this.setAttribute(SIGNATURE, signature);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void sign(Map headers, byte[] body, PrivateKey defaultKey) throws SignatureException {
        PrivateKey key;
        PrivateKey privateKey = key = this.privateKey == null ? defaultKey : this.privateKey;
        if (key == null) {
            throw new SignatureException(Messages.MESSAGES.privateKeyIsNull());
        }
        this.attributes.put(VERSION, "1");
        this.attributes.put(ALGORITHM, SigningAlgorithm.SHA256withRSA.getRfcNotation());
        this.attributes.put(CANONICALIZATION, "simple/simple");
        String algorithm = SigningAlgorithm.SHA256withRSA.getJavaSecNotation();
        String hashAlgorithm = SigningAlgorithm.SHA256withRSA.getJavaHashNotation();
        Signature signature = null;
        try {
            signature = Signature.getInstance(algorithm);
            signature.initSign(key);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
        if (this.headers.size() > 0) {
            StringBuffer headerCat = new StringBuffer();
            boolean count = false;
            for (int i = 0; i < this.headers.size(); ++i) {
                String name = this.headers.get(i);
                if (i > 0) {
                    headerCat.append(":");
                }
                headerCat.append(name);
            }
            this.attributes.put(HEADERS, headerCat.toString());
            this.updateSignatureWithHeader(headers, signature);
        }
        if (body != null && this.bodyHashRequired) {
            String encodedBodyHash = this.calculateEncodedHash(body, hashAlgorithm);
            this.attributes.put(BODY_HASH, encodedBodyHash);
        }
        StringBuffer dosetaBuffer = new StringBuffer();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (first) {
                first = false;
            } else {
                dosetaBuffer.append(";");
            }
            dosetaBuffer.append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (!first) {
            dosetaBuffer.append(";");
        }
        dosetaBuffer.append("b=");
        String dosetaHeader = dosetaBuffer.toString();
        signature.update(dosetaHeader.getBytes());
        byte[] signed = signature.sign();
        this.setSignature(signed);
        String base64Signature = Base64.getEncoder().encodeToString(signed);
        this.headerValue = dosetaHeader = dosetaHeader + base64Signature;
    }

    private String calculateEncodedHash(byte[] body, String hashAlgorithm) throws SignatureException {
        byte[] bodyHash = this.hash(body, hashAlgorithm);
        return Base64.getEncoder().encodeToString(bodyHash);
    }

    private byte[] hash(byte[] body, String hashAlgorithm) throws SignatureException {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(hashAlgorithm);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
        int length = body.length;
        if (this.attributes.containsKey(LENGTH)) {
            length = Integer.parseInt(this.attributes.get(LENGTH));
        }
        byte[] bodyHash = null;
        digest.update(body, 0, length);
        bodyHash = digest.digest();
        return bodyHash;
    }

    private MultivaluedMap<String, String> updateSignatureWithHeader(Map transmittedHeaders, Signature signature) throws SignatureException {
        MultivaluedMapImpl verifiedHeaders = new MultivaluedMapImpl();
        List<String> list = this.headers;
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (String name : list) {
            int index = 0;
            if (count.containsKey(name)) {
                index = (Integer)count.get(name);
                ++index;
            }
            count.put(name, index);
            Object v = transmittedHeaders.get(name);
            if (v == null) {
                throw new SignatureException(Messages.MESSAGES.unableToFindHeader(name, index > 0 ? "[" + index + "]" : ""));
            }
            if (v instanceof List) {
                List l = (List)v;
                int i = l.size() - 1 - index;
                if (i < 0) {
                    throw new SignatureException(Messages.MESSAGES.unableToFindHeader(name, index > 0 ? "[" + index + "]" : ""));
                }
                v = l.get(i);
            } else if (index > 0) {
                throw new SignatureException(Messages.MESSAGES.unableToFindHeader(name, index > 0 ? "[" + index + "]" : ""));
            }
            String entry = name + ":" + v.toString() + "\r\n";
            signature.update(entry.getBytes());
            verifiedHeaders.add((Object)name, (Object)v.toString());
        }
        return verifiedHeaders;
    }

    public MultivaluedMap<String, String> verify(Map headers, byte[] body, PublicKey key) throws SignatureException {
        return this.verify(true, headers, body, key);
    }

    public MultivaluedMap<String, String> verify(boolean bodyHashRequired, Map headers, byte[] body, PublicKey key) throws SignatureException {
        if (key == null) {
            throw new SignatureException(Messages.MESSAGES.noKeyToVerifyWith());
        }
        String algorithm = this.getAlgorithm();
        if (algorithm == null || !SigningAlgorithm.SHA256withRSA.getRfcNotation().toLowerCase().equals(algorithm.toLowerCase())) {
            throw new SignatureException(Messages.MESSAGES.unsupportedAlgorithm(algorithm));
        }
        Signature verifier = null;
        try {
            verifier = Signature.getInstance(SigningAlgorithm.SHA256withRSA.getJavaSecNotation());
            verifier.initVerify(key);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
        String encodedBh = this.attributes.get(BODY_HASH);
        if (encodedBh == null) {
            if (body != null && bodyHashRequired) {
                throw new SignatureException(Messages.MESSAGES.thereWasNoBodyHash());
            }
        } else {
            byte[] bh = this.hash(body, SigningAlgorithm.SHA256withRSA.getJavaHashNotation());
            byte[] enclosedBh = null;
            enclosedBh = Base64.getDecoder().decode(encodedBh);
            if (!Arrays.equals(bh, enclosedBh)) {
                throw new SignatureException(Messages.MESSAGES.bodyHashesDoNotMatch());
            }
        }
        MultivaluedMap<String, String> verifiedHeaders = this.updateSignatureWithHeader(headers, verifier);
        ParameterParser parser = new ParameterParser();
        String strippedHeader = parser.setAttribute(this.headerValue.toCharArray(), 0, this.headerValue.length(), ';', SIGNATURE, "");
        verifier.update(strippedHeader.getBytes());
        if (!verifier.verify(this.getSignature())) {
            throw new SignatureException(Messages.MESSAGES.failedToVerifySignature());
        }
        return verifiedHeaders;
    }
}

