/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.FilterLocation;
import org.wildfly.extension.undertow.UndertowFilter;
import org.wildfly.extension.undertow.filters.FilterService;

public class FilterRef
implements Service<FilterRef>,
UndertowFilter {
    private final Consumer<FilterRef> serviceConsumer;
    private final Supplier<FilterService> filter;
    private final Supplier<FilterLocation> location;
    private final Predicate predicate;
    private final int priority;

    FilterRef(Consumer<FilterRef> serviceConsumer, Supplier<FilterService> filter, Supplier<FilterLocation> location, Predicate predicate, int priority) {
        this.serviceConsumer = serviceConsumer;
        this.filter = filter;
        this.location = location;
        this.predicate = predicate;
        this.priority = priority;
    }

    public void start(StartContext context) throws StartException {
        this.location.get().addFilter(this);
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        this.location.get().removeFilter(this);
    }

    public HttpHandler createHttpHandler(HttpHandler next) {
        return this.filter.get().createHttpHandler(this.predicate, next);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public FilterRef getValue() throws IllegalStateException {
        return this;
    }

    public HttpHandler wrap(HttpHandler handler) {
        return this.filter.get().createHttpHandler(this.predicate, handler);
    }
}

