/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;
import org.wildfly.extension.messaging.activemq.ha.ReplicationMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationSlaveDefinition;

public class ReplicationColocatedDefinition
extends PersistentResourceDefinition {
    public static final Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(HAAttributes.REQUEST_BACKUP, HAAttributes.BACKUP_REQUEST_RETRIES, HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL, HAAttributes.MAX_BACKUPS, HAAttributes.BACKUP_PORT_OFFSET, HAAttributes.EXCLUDED_CONNECTORS));
    public static final ReplicationColocatedDefinition INSTANCE = new ReplicationColocatedDefinition();

    private ReplicationColocatedDefinition() {
        super(MessagingExtension.REPLICATION_COLOCATED_PATH, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ManagementHelper.createAddOperation("ha-policy", false, ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQReloadRequiredHandlers.WriteAttributeHandler writeAttribute = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeAttribute);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(new PersistentResourceDefinition[]{ReplicationMasterDefinition.CONFIGURATION_INSTANCE, ReplicationSlaveDefinition.CONFIGURATION_INSTANCE}));
    }
}

