/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class MetadataMortalCacheValue
extends ImmortalCacheValue
implements MetadataAware {
    Metadata metadata;
    long created;

    public MetadataMortalCacheValue(Object value, Metadata metadata, long created) {
        this(value, null, metadata, created);
    }

    protected MetadataMortalCacheValue(Object value, PrivateMetadata internalMetadata, Metadata metadata, long created) {
        super(value, internalMetadata);
        this.metadata = metadata;
        this.created = created;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new MetadataMortalCacheEntry(key, this.value, this.internalMetadata, this.metadata, this.created);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public final long getCreated() {
        return this.created;
    }

    @Override
    public final long getLifespan() {
        return this.metadata.lifespan();
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredMortal(this.metadata.lifespan(), this.created, now);
    }

    @Override
    public long getExpiryTime() {
        long lifespan = this.metadata.lifespan();
        return lifespan > -1L ? this.created + lifespan : -1L;
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", created=").append(this.created);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataMortalCacheValue> {
        public void writeObject(ObjectOutput output, MetadataMortalCacheValue mcv) throws IOException {
            output.writeObject(mcv.value);
            output.writeObject(mcv.internalMetadata);
            output.writeObject(mcv.metadata);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)mcv.created);
        }

        public MetadataMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object value = input.readObject();
            PrivateMetadata internalMetadata = (PrivateMetadata)input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            return new MetadataMortalCacheValue(value, internalMetadata, metadata, created);
        }

        public Integer getId() {
            return 43;
        }

        public Set<Class<? extends MetadataMortalCacheValue>> getTypeClasses() {
            return Collections.singleton(MetadataMortalCacheValue.class);
        }
    }
}

