/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiOnRequestCall;
import io.smallrye.mutiny.operators.multi.MultiOnRequestInvoke;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.Supplier;

public class MultiOnRequest<T> {
    private final Multi<T> upstream;

    public MultiOnRequest(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> invoke(LongConsumer consumer) {
        LongConsumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return Infrastructure.onMultiCreation(new MultiOnRequestInvoke<T>(this.upstream, actual));
    }

    public Multi<T> invoke(Runnable action) {
        Runnable actual = ParameterValidation.nonNull(action, "action");
        return this.invoke((long ignored) -> actual.run());
    }

    public Multi<T> call(LongFunction<Uni<?>> mapper) {
        return Infrastructure.onMultiCreation(new MultiOnRequestCall<T>(this.upstream, ParameterValidation.nonNull(mapper, "mapper")));
    }

    public Multi<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.call((long ignored) -> (Uni)actual.get());
    }
}

