/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.patching.runner.PatchModuleInvalidationUtils;
import org.jboss.as.patching.runner.PatchingTaskContext;

public class PatchReenableJarTool {
    static FilenameFilter JAR_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };

    public static void main(String ... args) throws IOException {
        String path = args[0];
        File jbossHome = new File(path);
        if (!jbossHome.exists()) {
            throw PatchReenableJarTool.notFound(jbossHome);
        }
        File modules = new File(jbossHome, "modules");
        if (!modules.exists()) {
            throw PatchReenableJarTool.notFound(modules);
        }
        File base = new File(modules, "system/layers/base");
        if (!base.exists()) {
            throw PatchReenableJarTool.notFound(base);
        }
        ArrayList<File> jars = new ArrayList<File>();
        PatchReenableJarTool.findModuleRoots(base, jars);
        for (File file : jars) {
            PatchModuleInvalidationUtils.processFile(null, file, PatchingTaskContext.Mode.ROLLBACK);
        }
    }

    static void findModuleRoots(File file, List<File> jars) {
        File moduleXml = new File(file, "module.xml");
        if (moduleXml.exists()) {
            PatchReenableJarTool.findJars(file, jars);
        } else {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    if (child.getName().equals(".overlays") || !child.isDirectory()) continue;
                    PatchReenableJarTool.findModuleRoots(child, jars);
                }
            }
        }
    }

    static void findJars(File moduleRoot, List<File> jars) {
        File[] files = moduleRoot.listFiles(JAR_FILTER);
        if (files != null) {
            for (File jar : files) {
                jars.add(jar);
            }
        }
    }

    static FileNotFoundException notFound(File file) {
        return new FileNotFoundException(file.getAbsolutePath() + " does not exist");
    }
}

