/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import io.undertow.util.NetworkUtils;

public class RemoteDomainControllerConnectionConfiguration {
    private final String remoteDcHost;
    private final int remoteDcPort;
    private final String remoteDcProtocol;

    public RemoteDomainControllerConnectionConfiguration(String protocol, String host, int port) {
        assert (protocol != null) : "protocol is null";
        assert (host != null) : "host is null";
        this.remoteDcHost = NetworkUtils.formatPossibleIpv6Address((String)host);
        this.remoteDcPort = port;
        this.remoteDcProtocol = protocol;
    }

    public String getHost() {
        return this.remoteDcHost;
    }

    public int getPort() {
        return this.remoteDcPort;
    }

    public String getProtocol() {
        return this.remoteDcProtocol;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{protocol=" + this.remoteDcProtocol + ",host=" + this.remoteDcHost + ",port=" + this.remoteDcPort + '}';
    }
}

