/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.scheduler;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.function.Supplier;
import org.wildfly.clustering.ee.cache.scheduler.FastConcurrentDirectDeque;
import org.wildfly.clustering.ee.cache.scheduler.PortableConcurrentDirectDeque;

public interface ConcurrentDirectDeque<E>
extends Deque<E> {
    public static final Supplier<ConcurrentDirectDeque> FACTORY = new Supplier<ConcurrentDirectDeque>(){
        private final Constructor<? extends ConcurrentDirectDeque> constructor = this.findConstructor();

        private Constructor<? extends ConcurrentDirectDeque> findConstructor() {
            Class queueClass = PortableConcurrentDirectDeque.class;
            try {
                queueClass = new FastConcurrentDirectDeque().getClass();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                return queueClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        }

        @Override
        public ConcurrentDirectDeque get() {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    };

    public static <K> ConcurrentDirectDeque<K> newInstance() {
        return FACTORY.get();
    }

    public Object offerFirstAndReturnToken(E var1);

    public Object offerLastAndReturnToken(E var1);

    public void removeToken(Object var1);

    @Override
    default public boolean add(E e) {
        return this.offerLast(e);
    }

    @Override
    default public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    default public E peek() {
        return this.peekFirst();
    }

    @Override
    default public E pop() {
        return this.removeFirst();
    }

    @Override
    default public void push(E e) {
        this.addFirst(e);
    }

    @Override
    default public E element() {
        return this.getFirst();
    }

    @Override
    default public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    default public E poll() {
        return this.pollFirst();
    }

    @Override
    default public E remove() {
        return this.removeFirst();
    }
}

