/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.tx;

import java.util.function.Function;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.cache.tx.TransactionalBatch;

public class TransactionalBatcher<E extends RuntimeException>
implements Batcher<TransactionBatch> {
    private static final BatchContext PASSIVE_BATCH_CONTEXT = () -> {};
    private static final TransactionBatch NON_TX_BATCH = new TransactionBatch(){

        public void close() {
        }

        public void discard() {
        }

        public Batch.State getState() {
            return Batch.State.ACTIVE;
        }

        @Override
        public Transaction getTransaction() {
            return null;
        }

        @Override
        public TransactionBatch interpose() {
            return this;
        }
    };
    private static final ThreadLocal<TransactionBatch> CURRENT_BATCH = new ThreadLocal();
    private static final Synchronization CURRENT_BATCH_SYNCHRONIZATION = new Synchronization(){

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            TransactionalBatcher.setCurrentBatch(null);
        }
    };
    private final TransactionManager tm;
    private final Function<Throwable, E> exceptionTransformer;

    static TransactionBatch getCurrentBatch() {
        return CURRENT_BATCH.get();
    }

    static void setCurrentBatch(TransactionBatch batch) {
        if (batch != null) {
            CURRENT_BATCH.set(batch);
        } else {
            CURRENT_BATCH.remove();
        }
    }

    public TransactionalBatcher(TransactionManager tm, Function<Throwable, E> exceptionTransformer) {
        this.tm = tm;
        this.exceptionTransformer = exceptionTransformer;
    }

    public TransactionBatch createBatch() {
        if (this.tm == null) {
            return NON_TX_BATCH;
        }
        TransactionalBatch<E> batch = TransactionalBatcher.getCurrentBatch();
        try {
            if (batch != null && batch.getState() == Batch.State.ACTIVE) {
                return batch.interpose();
            }
            this.tm.suspend();
            this.tm.begin();
            Transaction tx = this.tm.getTransaction();
            tx.registerSynchronization(CURRENT_BATCH_SYNCHRONIZATION);
            batch = new TransactionalBatch<E>(tx, this.exceptionTransformer);
            TransactionalBatcher.setCurrentBatch(batch);
            return batch;
        }
        catch (NotSupportedException | RollbackException | SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
    }

    public BatchContext resumeBatch(TransactionBatch batch) {
        Transaction tx;
        TransactionBatch existingBatch = TransactionalBatcher.getCurrentBatch();
        if (batch == existingBatch) {
            return PASSIVE_BATCH_CONTEXT;
        }
        Transaction transaction = tx = batch != null ? batch.getTransaction() : null;
        if (batch == null || tx == null) {
            TransactionalBatcher.setCurrentBatch(batch);
            return () -> TransactionalBatcher.setCurrentBatch(existingBatch);
        }
        try {
            if (existingBatch != null) {
                Transaction existingTx = this.tm.suspend();
                if (existingBatch.getTransaction() != existingTx) {
                    throw new IllegalStateException();
                }
            }
            this.tm.resume(tx);
            TransactionalBatcher.setCurrentBatch(batch);
            return () -> {
                block7: {
                    try {
                        this.tm.suspend();
                        if (existingBatch == null) break block7;
                        try {
                            this.tm.resume(existingBatch.getTransaction());
                        }
                        catch (InvalidTransactionException e) {
                            throw (RuntimeException)this.exceptionTransformer.apply(e);
                        }
                    }
                    catch (SystemException e) {
                        throw (RuntimeException)this.exceptionTransformer.apply(e);
                    }
                    finally {
                        TransactionalBatcher.setCurrentBatch(existingBatch);
                    }
                }
            };
        }
        catch (InvalidTransactionException | SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
    }

    public TransactionBatch suspendBatch() {
        if (this.tm == null) {
            return NON_TX_BATCH;
        }
        TransactionBatch batch = TransactionalBatcher.getCurrentBatch();
        if (batch != null) {
            try {
                Transaction tx = this.tm.suspend();
                if (batch.getTransaction() != tx) {
                    throw new IllegalStateException();
                }
            }
            catch (SystemException e) {
                throw (RuntimeException)this.exceptionTransformer.apply(e);
            }
            finally {
                TransactionalBatcher.setCurrentBatch(null);
            }
        }
        return batch;
    }
}

