/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.AbstractServerChannel;
import io.netty.channel.ChannelException;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.ServerSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.StreamConnection;
import org.xnio.channels.AcceptingChannel;
import org.xnio.netty.transport.WrappingXnioSocketChannel;
import org.xnio.netty.transport.XnioEventLoop;
import org.xnio.netty.transport.XnioServerSocketChannelConfigImpl;

abstract class AbstractXnioServerSocketChannel
extends AbstractServerChannel
implements ServerSocketChannel {
    private final XnioServerSocketChannelConfigImpl config = new XnioServerSocketChannelConfigImpl(this);
    private static final ThreadLocal<StreamConnection[]> connections = new ThreadLocal();

    AbstractXnioServerSocketChannel() {
    }

    private static StreamConnection[] connectionsArray(int size) {
        StreamConnection[] array = connections.get();
        if (array == null || array.length < size) {
            array = new StreamConnection[size];
            connections.set(array);
        }
        return array;
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof XnioEventLoop;
    }

    public boolean isActive() {
        return this.isOpen();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public XnioServerSocketChannelConfigImpl config() {
        return this.config;
    }

    <T> T getOption(Option<T> option) {
        try {
            return this.getOption0(option);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    <T> void setOption(Option<T> option, T value) {
        try {
            this.setOption0(option, value);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    protected SocketAddress localAddress0() {
        AcceptingChannel channel = this.xnioChannel();
        if (channel == null) {
            return null;
        }
        return channel.getLocalAddress();
    }

    protected void doClose() throws Exception {
        AcceptingChannel channel = this.xnioChannel();
        if (channel == null) {
            return;
        }
        channel.suspendAccepts();
        channel.close();
    }

    protected void doBeginRead() throws Exception {
        AcceptingChannel channel = this.xnioChannel();
        if (channel == null) {
            return;
        }
        channel.resumeAccepts();
    }

    public boolean isOpen() {
        AcceptingChannel channel = this.xnioChannel();
        return channel == null || channel.isOpen();
    }

    protected abstract AcceptingChannel xnioChannel();

    protected abstract <T> void setOption0(Option<T> var1, T var2) throws IOException;

    protected abstract <T> T getOption0(Option<T> var1) throws IOException;

    final class AcceptListener
    implements ChannelListener<AcceptingChannel<StreamConnection>> {
        AcceptListener() {
        }

        public void handleEvent(AcceptingChannel<StreamConnection> channel) {
            EventLoop loop;
            if (!AbstractXnioServerSocketChannel.this.config.isAutoRead()) {
                channel.suspendAccepts();
            }
            if ((loop = AbstractXnioServerSocketChannel.this.eventLoop()).inEventLoop()) {
                try {
                    StreamConnection conn;
                    int messagesToRead = AbstractXnioServerSocketChannel.this.config().getMaxMessagesPerRead();
                    for (int i = 0; i < messagesToRead && (conn = (StreamConnection)channel.accept()) != null; ++i) {
                        AbstractXnioServerSocketChannel.this.pipeline().fireChannelRead((Object)new WrappingXnioSocketChannel(AbstractXnioServerSocketChannel.this, conn));
                    }
                }
                catch (Throwable cause) {
                    AbstractXnioServerSocketChannel.this.pipeline().fireExceptionCaught(cause);
                }
                AbstractXnioServerSocketChannel.this.pipeline().fireChannelReadComplete();
            } else {
                Throwable cause;
                int messagesToRead = AbstractXnioServerSocketChannel.this.config().getMaxMessagesPerRead();
                final StreamConnection[] array = AbstractXnioServerSocketChannel.connectionsArray(messagesToRead);
                try {
                    for (int i = 0; i < messagesToRead; ++i) {
                        StreamConnection conn;
                        array[i] = conn = (StreamConnection)channel.accept();
                        if (conn == null) break;
                    }
                    cause = null;
                }
                catch (Throwable e) {
                    cause = e;
                }
                final Throwable acceptError = cause;
                AbstractXnioServerSocketChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            StreamConnection conn;
                            for (int i = 0; i < array.length && (conn = array[i]) != null; ++i) {
                                AbstractXnioServerSocketChannel.this.pipeline().fireChannelRead((Object)new WrappingXnioSocketChannel(AbstractXnioServerSocketChannel.this, conn));
                            }
                        }
                        catch (Throwable cause) {
                            AbstractXnioServerSocketChannel.this.pipeline().fireExceptionCaught(cause);
                        }
                        if (acceptError != null) {
                            AbstractXnioServerSocketChannel.this.pipeline().fireExceptionCaught(acceptError);
                        }
                        AbstractXnioServerSocketChannel.this.pipeline().fireChannelReadComplete();
                    }
                });
            }
        }
    }
}

