/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ObjectMapAttributeDefinition
extends MapAttributeDefinition {
    private final ObjectTypeAttributeDefinition valueType;

    private ObjectMapAttributeDefinition(Builder builder) {
        super(builder);
        this.valueType = builder.valueType;
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            this.valueType.addCapabilityRequirements(context, resource, attributeValue);
        }
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        if (attributeValue.isDefined()) {
            this.valueType.removeCapabilityRequirements(context, resource, attributeValue);
        }
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addValueTypeDescription(node, this.getName(), bundle, true, resolver, locale);
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        this.addValueTypeDescription(node, this.valueType.getName(), bundle, false, null, null);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addValueTypeDescription(node, this.getName(), bundle, false, resolver, locale);
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle, boolean forOperation, ResourceDescriptionResolver resolver, Locale locale) {
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        node.get("description");
        node.get("expressions-allowed").set(this.valueType.isAllowExpression());
        if (forOperation) {
            node.get("required").set(!this.valueType.isAllowNull());
        }
        node.get("nillable").set(this.isAllowNull());
        ModelNode defaultValue = this.valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            node.get("default").set(defaultValue);
        }
        if ((measurementUnit = this.valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            node.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = this.valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                node.get("alternatives").add(alternative);
            }
        }
        if ((requires = this.valueType.getRequires()) != null) {
            for (String required : requires) {
                node.get("requires").add(required);
            }
        }
        if ((validator = this.valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        node.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        node.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        node.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        node.get("max").set(max.longValue());
                    }
                }
            }
        }
        this.addAllowedValuesToDescription(node, validator);
        this.valueType.addValueTypeDescription(node, prefix, bundle, forOperation, resolver, locale);
    }

    public final ObjectTypeAttributeDefinition getValueType() {
        return this.valueType;
    }

    public static Builder create(String name, ObjectTypeAttributeDefinition valueType) {
        return new Builder(name, valueType);
    }

    private static class MapParameterCorrector
    implements ParameterCorrector {
        private final ParameterCorrector listCorrector;
        private final ParameterCorrector valueCorrector;

        private MapParameterCorrector(ParameterCorrector listCorrector, ParameterCorrector valueCorrector) {
            this.listCorrector = listCorrector;
            this.valueCorrector = valueCorrector;
        }

        @Override
        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            ModelNode result = newValue;
            if (newValue.isDefined()) {
                for (String key : newValue.keys()) {
                    ModelNode toCorrect = newValue.get(key);
                    ModelNode corrected = this.valueCorrector.correct(toCorrect, currentValue.has(key) ? currentValue.get(key) : new ModelNode());
                    if (corrected.equals(toCorrect)) continue;
                    toCorrect.set(corrected);
                }
            }
            if (this.listCorrector != null) {
                result = this.listCorrector.correct(result, currentValue);
            }
            return result;
        }
    }

    public static final class Builder
    extends MapAttributeDefinition.Builder<Builder, ObjectMapAttributeDefinition> {
        private final ObjectTypeAttributeDefinition valueType;

        public Builder(String name, ObjectTypeAttributeDefinition valueType) {
            super(name);
            this.valueType = valueType;
            this.setElementValidator(valueType.getValidator());
            this.setAttributeParser(AttributeParsers.OBJECT_MAP_WRAPPED);
            this.setAttributeMarshaller(AttributeMarshaller.OBJECT_MAP_MARSHALLER);
        }

        public static Builder of(String name, ObjectTypeAttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        @Override
        public ObjectMapAttributeDefinition build() {
            List<AccessConstraintDefinition> valueConstraints = this.valueType.getAccessConstraints();
            if (!valueConstraints.isEmpty()) {
                LinkedHashSet<AccessConstraintDefinition> acdSet = new LinkedHashSet<AccessConstraintDefinition>();
                AccessConstraintDefinition[] curAcds = this.getAccessConstraints();
                if (curAcds != null && curAcds.length > 0) {
                    Collections.addAll(acdSet, curAcds);
                }
                acdSet.addAll(valueConstraints);
                this.setAccessConstraints(acdSet.toArray(new AccessConstraintDefinition[acdSet.size()]));
            }
            if (this.valueType.getCorrector() != null) {
                this.setCorrector(new MapParameterCorrector(this.getCorrector(), this.valueType.getCorrector()));
            }
            return new ObjectMapAttributeDefinition(this);
        }
    }
}

