/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.nio.charset.Charset;
import java.nio.file.Path;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.CharsetValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.password.spec.Encoding;

class FileSystemRealmDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", FileAttributeDefinitions.PATH).setAttributeGroup("file")).setRequired(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", FileAttributeDefinitions.RELATIVE_TO).setAttributeGroup("file")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition LEVELS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("levels", ModelType.INT, true).setDefaultValue(new ModelNode(2))).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ENCODED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("encoded", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition HASH_ENCODING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-encoding", ModelType.STRING, true).setDefaultValue(new ModelNode("base64"))).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"base64", "hex"}))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition HASH_CHARSET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hash-charset", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode("UTF-8"))).setValidator((ParameterValidator)new CharsetValidator())).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PATH, RELATIVE_TO, LEVELS, ENCODED, HASH_ENCODING, HASH_CHARSET};
    private static final AbstractAddStepHandler ADD = new RealmAddHandler();
    private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY);

    FileSystemRealmDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"filesystem-realm"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("filesystem-realm")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY, Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler handler = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    private static class RealmAddHandler
    extends BaseAddHandler {
        private RealmAddHandler() {
            super(Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY, ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            ServiceName mainServiceName = Capabilities.MODIFIABLE_SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            ServiceName aliasServiceName = Capabilities.SECURITY_REALM_RUNTIME_CAPABILITY.fromBaseCapability(address).getCapabilityServiceName();
            final int levels = LEVELS.resolveModelAttribute(context, model).asInt();
            final boolean encoded = ENCODED.resolveModelAttribute(context, model).asBoolean();
            final String path = PATH.resolveModelAttribute(context, model).asString();
            final String relativeTo = RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
            final String hashEncoding = HASH_ENCODING.resolveModelAttribute(context, model).asString();
            final String hashCharset = HASH_CHARSET.resolveModelAttribute(context, model).asString();
            final InjectedValue pathManagerInjector = new InjectedValue();
            final InjectedValue nameRewriterInjector = new InjectedValue();
            TrivialService<SecurityRealm> fileSystemRealmService = new TrivialService<SecurityRealm>(new TrivialService.ValueSupplier<SecurityRealm>(){
                private FileAttributeDefinitions.PathResolver pathResolver;

                @Override
                public SecurityRealm get() throws StartException {
                    this.pathResolver = FileAttributeDefinitions.pathResolver();
                    Path rootPath = this.pathResolver.path(path).relativeTo(relativeTo, (PathManager)pathManagerInjector.getOptionalValue()).resolve().toPath();
                    NameRewriter nameRewriter = (NameRewriter)nameRewriterInjector.getOptionalValue();
                    Charset charset = Charset.forName(hashCharset);
                    Encoding encoding = "hex".equals(hashEncoding) ? Encoding.HEX : Encoding.BASE64;
                    return nameRewriter != null ? new FileSystemSecurityRealm(rootPath, nameRewriter, levels, encoded, encoding, charset) : new FileSystemSecurityRealm(rootPath, NameRewriter.IDENTITY_REWRITER, levels, encoded, encoding, charset);
                }

                @Override
                public void dispose() {
                    if (this.pathResolver != null) {
                        this.pathResolver.clear();
                        this.pathResolver = null;
                    }
                }
            });
            ServiceBuilder serviceBuilder = serviceTarget.addService(mainServiceName, fileSystemRealmService).addAliases(new ServiceName[]{aliasServiceName});
            if (relativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, (Injector)pathManagerInjector);
                serviceBuilder.requires(FileAttributeDefinitions.pathName(relativeTo));
            }
            serviceBuilder.install();
        }
    }
}

