/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.TableName;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class OracleTableManager
extends AbstractTableManager {
    private static final Log log = (Log)LogFactory.getLog(OracleTableManager.class, Log.class);
    private static final int MAX_INDEX_IDENTIFIER_SIZE = 30;
    private static final String INDEX_PREFIX = "IDX";

    OracleTableManager(InitializationContext ctx, ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, String cacheName) {
        super(ctx, connectionFactory, config, metaData, cacheName, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Connection connection, TableName tableName) {
        Objects.requireNonNull(tableName, "table name is mandatory");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaPattern = tableName.getSchema() == null ? metaData.getUserName() : tableName.getSchema();
            rs = metaData.getTables(null, schemaPattern, tableName.getName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            JdbcUtil.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            if (log.isTraceEnabled()) {
                log.tracef(e, "SQLException occurs while checking the table %s", tableName);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.safeClose(rs);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean indexExists(String indexName, Connection conn) throws PersistenceException {
        ResultSet rs;
        block7: {
            boolean bl;
            block6: {
                rs = null;
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    rs = meta.getIndexInfo(null, null, this.dataTableName.toString(), false, false);
                    while (rs.next()) {
                        String index = rs.getString("INDEX_NAME");
                        if (!indexName.equalsIgnoreCase(index)) continue;
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (SQLException e) {
                    try {
                        throw new PersistenceException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        throw throwable;
                    }
                }
            }
            JdbcUtil.safeClose(rs);
            return bl;
        }
        JdbcUtil.safeClose(rs);
        return false;
    }

    @Override
    public String getIndexName(boolean withIdentifier, String indexExt) {
        if (indexExt.equals("timestamp_index")) {
            indexExt = INDEX_PREFIX;
        }
        int maxNameSize = 30 - indexExt.length() - 1;
        String plainTableName = this.dataTableName.toString().replace(this.identifierQuoteString, "");
        String truncatedName = plainTableName.length() > maxNameSize ? plainTableName.substring(0, maxNameSize) : plainTableName;
        String indexName = indexExt + "_" + truncatedName;
        if (withIdentifier) {
            return this.identifierQuoteString + indexName + this.identifierQuoteString;
        }
        return indexName;
    }

    protected String getDropTimestampSql() {
        return String.format("DROP INDEX %s", this.getIndexName(true, "timestamp_index"));
    }

    @Override
    protected String initInsertRowSql() {
        if (this.dbMetadata.isSegmentedDisabled()) {
            return String.format("INSERT INTO %s (%s,%s,%s) VALUES (?,?,?)", this.dataTableName, this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName());
        }
        return String.format("INSERT INTO %s (%s,%s,%s,%s) VALUES (?,?,?,?)", this.dataTableName, this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName(), this.config.segmentColumnName());
    }

    @Override
    protected String initUpdateRowSql() {
        return String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = ?", this.dataTableName, this.config.timestampColumnName(), this.config.dataColumnName(), this.config.idColumnName());
    }

    @Override
    public String initUpsertRowSql() {
        if (this.dbMetadata.isSegmentedDisabled()) {
            return String.format("MERGE INTO %1$s t USING (SELECT ? %2$s, ? %3$s, ? %4$s from dual) tmp ON (t.%2$s = tmp.%2$s) WHEN MATCHED THEN UPDATE SET t.%3$s = tmp.%3$s, t.%4$s = tmp.%4$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s)", this.dataTableName, this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName());
        }
        return String.format("MERGE INTO %1$s t USING (SELECT ? %2$s, ? %3$s, ? %4$s, ? %5$s from dual) tmp ON (t.%2$s = tmp.%2$s) WHEN MATCHED THEN UPDATE SET t.%3$s = tmp.%3$s, t.%4$s = tmp.%4$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s, %5$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s, tmp.%5$s)", this.dataTableName, this.config.idColumnName(), this.config.timestampColumnName(), this.config.dataColumnName(), this.config.segmentColumnName());
    }

    @Override
    public void prepareUpsertStatement(PreparedStatement ps, String key, long timestamp, int segment, ByteBuffer byteBuffer) throws SQLException {
        ps.setString(1, key);
        ps.setLong(2, timestamp);
        ps.setBlob(3, new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        if (!this.dbMetadata.isSegmentedDisabled()) {
            ps.setInt(4, segment);
        }
    }

    @Override
    public void prepareUpdateStatement(PreparedStatement ps, String key, long timestamp, int segment, ByteBuffer byteBuffer) throws SQLException {
        ps.setLong(1, timestamp);
        ps.setBinaryStream(2, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        ps.setString(3, key);
        if (!this.dbMetadata.isSegmentedDisabled()) {
            ps.setInt(4, segment);
        }
    }
}

