/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.PathUtil;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class ExplodedDeploymentRemoveContentHandler
implements OperationStepHandler {
    private final ContentRepository contentRepository;
    private final ServerEnvironment serverEnvironment;

    public ExplodedDeploymentRemoveContentHandler(ContentRepository contentRepository, ServerEnvironment serverEnvironment) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.serverEnvironment = serverEnvironment;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        byte[] newHash;
        if (context.getProcessType() == ProcessType.SELF_CONTAINED) {
            throw ServerLogger.ROOT_LOGGER.cannotRemoveContentFromSelfContainedServer();
        }
        Resource deploymentResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItemNode = DeploymentHandlerUtil.getContentItem(deploymentResource);
        if (!DeploymentHandlerUtil.isManaged(contentItemNode)) {
            throw ServerLogger.ROOT_LOGGER.cannotRemoveContentFromUnmanagedDeployment();
        }
        if (DeploymentHandlerUtil.isArchive(contentItemNode)) {
            throw ServerLogger.ROOT_LOGGER.cannotRemoveContentFromUnexplodedDeployment();
        }
        final String managementName = context.getCurrentAddress().getLastElement().getValue();
        final PathAddress address = PathAddress.pathAddress((String)"deployment", (String)managementName);
        final byte[] oldHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItemNode).asBytes();
        final List paths = DeploymentAttributes.REMOVED_PATHS.unwrap((ExpressionResolver)context, operation);
        if (operation.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) {
            newHash = DeploymentHandlerUtil.addFromHash(this.contentRepository, operation, managementName, address, context);
        } else {
            try {
                newHash = this.contentRepository.removeContentFromExploded(oldHash, paths);
            }
            catch (ExplodedContentException ex) {
                throw DeploymentHandlerUtils.createFailureException(ex.toString());
            }
        }
        contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(newHash);
        if (!paths.isEmpty() && DeploymentAttributes.ENABLED.resolveModelAttribute(context, deploymentResource.getModel()).asBoolean()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    block5: {
                        try {
                            ExecutorService executor = (ExecutorService)context.getServiceRegistry(false).getRequiredService(Services.JBOSS_SERVER_EXECUTOR).getValue();
                            CountDownLatch latch = ExplodedDeploymentRemoveContentHandler.this.delete(executor, paths, managementName);
                            if (latch == null) break block5;
                            try {
                                if (!latch.await(60L, TimeUnit.SECONDS)) {
                                    return;
                                }
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                                throw DeploymentHandlerUtils.createFailureException(ex.toString());
                            }
                        }
                        catch (IOException ex) {
                            throw DeploymentHandlerUtils.createFailureException(ex.toString());
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        DeploymentHandlerUtils.addFlushHandler(context, this.contentRepository, new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    if (!(oldHash == null || newHash != null && Arrays.equals(oldHash, newHash))) {
                        ExplodedDeploymentRemoveContentHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress(address, oldHash));
                    }
                    if (newHash != null) {
                        ExplodedDeploymentRemoveContentHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress(address, newHash));
                    }
                } else if (!(newHash == null || oldHash != null && Arrays.equals(oldHash, newHash))) {
                    ExplodedDeploymentRemoveContentHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress(address, newHash));
                }
            }
        });
    }

    private CountDownLatch delete(ExecutorService executor, final List<String> paths, final String managementName) throws IOException {
        CountDownLatch result;
        final Path runtimeDeployedPath = DeploymentHandlerUtil.getExplodedDeploymentRoot(this.serverEnvironment, managementName);
        if (Files.exists(runtimeDeployedPath, new LinkOption[0])) {
            result = new CountDownLatch(1);
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (String path : paths) {
                            try {
                                PathUtil.deleteRecursively((Path)PathUtil.resolveSecurely((Path)runtimeDeployedPath, (String)path));
                            }
                            catch (IOException ex) {
                                ServerLogger.DEPLOYMENT_LOGGER.couldNotDeleteFile(ex, path, managementName);
                            }
                        }
                    }
                    finally {
                        result.countDown();
                    }
                }
            };
            executor.submit(r);
        } else {
            result = null;
        }
        return result;
    }
}

