/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.marshalling.SimpleDataOutput;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JBossByteBufferMarshaller
implements ByteBufferMarshaller {
    private final MarshallerFactory factory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)Marshalling.class.getClassLoader());
    private final MarshallingConfigurationRepository repository;
    private final WeakReference<ClassLoader> loader;

    public JBossByteBufferMarshaller(MarshallingConfigurationRepository repository, ClassLoader loader) {
        this.repository = repository;
        this.loader = new WeakReference<ClassLoader>(loader);
    }

    private MarshallingConfiguration getMarshallingConfiguration(int version) {
        return this.repository.getMarshallingConfiguration(version);
    }

    /*
     * Exception decompiling
     */
    public Object readFrom(InputStream input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream output, Object value) throws IOException {
        int version = this.repository.getCurrentMarshallingVersion();
        try (SimpleDataOutput data = new SimpleDataOutput(Marshalling.createByteOutput((OutputStream)output));){
            IndexSerializer.UNSIGNED_BYTE.writeInt((DataOutput)data, version);
            ClassLoader loader = JBossByteBufferMarshaller.setThreadContextClassLoader((ClassLoader)this.loader.get());
            try (Marshaller marshaller = this.factory.createMarshaller(this.getMarshallingConfiguration(version));){
                marshaller.start((ByteOutput)data);
                marshaller.writeObject(value);
                marshaller.finish();
            }
            finally {
                JBossByteBufferMarshaller.setThreadContextClassLoader(loader);
            }
        }
    }

    public boolean isMarshallable(Object object) {
        if (object == null) {
            return true;
        }
        MarshallingConfiguration configuration = this.repository.getMarshallingConfiguration(this.repository.getCurrentMarshallingVersion());
        try {
            ObjectTable table = configuration.getObjectTable();
            if (table != null && table.getObjectWriter(object) != null) {
                return true;
            }
            ClassExternalizerFactory factory = configuration.getClassExternalizerFactory();
            if (factory != null && factory.getExternalizer(object.getClass()) != null) {
                return true;
            }
            SerializabilityChecker checker = configuration.getSerializabilityChecker();
            return (checker == null ? SerializabilityChecker.DEFAULT : checker).isSerializable(object.getClass());
        }
        catch (IOException e) {
            return false;
        }
    }

    private static ClassLoader setThreadContextClassLoader(ClassLoader loader) {
        return loader != null ? WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)loader) : null;
    }
}

