/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;

public final class Changeset
implements Iterable<LuceneWork> {
    private final List<LuceneWork> workList;
    private final Thread producer;
    private final IndexingMonitor monitor;
    private volatile boolean processed = false;

    public Changeset(List<LuceneWork> workList, Thread producer, IndexingMonitor monitor) {
        this.workList = workList;
        this.producer = producer;
        this.monitor = monitor;
    }

    @Override
    public Iterator<LuceneWork> iterator() {
        return this.workList.iterator();
    }

    IndexingMonitor getMonitor() {
        return this.monitor;
    }

    boolean isProcessed() {
        return this.processed;
    }

    public void markProcessed() {
        this.processed = true;
        LockSupport.unpark(this.producer);
    }
}

