/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class MultiWriteDrainableLinkedList<T> {
    private Node<T> first = null;
    private Node<T> last = null;

    public void add(T element) {
        Node<T> newnode = new Node<T>(element);
        this.addNode(newnode);
    }

    private synchronized void addNode(Node<T> newnode) {
        if (this.first == null) {
            this.first = newnode;
            this.last = newnode;
        } else {
            this.last.next = newnode;
            this.last = newnode;
        }
    }

    public Iterable<T> drainToDetachedIterable() {
        Node<T> head = this.drainHead();
        if (head != null) {
            return new DetachedNodeIterable<T>(head);
        }
        return null;
    }

    private synchronized Node<T> drainHead() {
        Node<T> head = this.first;
        this.first = null;
        this.last = null;
        return head;
    }

    static final class DetachedNodeIterator<T>
    implements Iterator<T> {
        private Node<T> current;

        DetachedNodeIterator(Node<T> head) {
            this.current = head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object v = this.current.value;
            this.current = this.current.next;
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator is unable to remove elements");
        }
    }

    static final class DetachedNodeIterable<T>
    implements Iterable<T> {
        private final Node<T> head;

        public DetachedNodeIterable(Node<T> head) {
            this.head = head;
        }

        @Override
        public Iterator<T> iterator() {
            return new DetachedNodeIterator<T>(this.head);
        }
    }

    static final class Node<T> {
        final T value;
        Node<T> next;

        Node(T x) {
            this.value = x;
        }
    }
}

