/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.impl.ExtendedBridgeProvider;
import org.hibernate.search.util.impl.CollectionHelper;

class NumericBridgeProvider
extends ExtendedBridgeProvider {
    private static final Map<String, NumericFieldBridge> numericBridges;
    private static final Set<Class<?>> TYPES_USING_STRING_FIELD_BY_DEFAULT;

    NumericBridgeProvider() {
    }

    @Override
    public FieldBridge provideFieldBridge(ExtendedBridgeProvider.ExtendedBridgeProviderContext bridgeContext) {
        if (!bridgeContext.isExplicitlyMarkedAsNumeric() && (bridgeContext.isId() || this.encodeWithStringFieldByDefault(bridgeContext.getReturnType()))) {
            return null;
        }
        return numericBridges.get(bridgeContext.getReturnType().getName());
    }

    private boolean encodeWithStringFieldByDefault(Class<?> clazz) {
        return TYPES_USING_STRING_FIELD_BY_DEFAULT.contains(clazz);
    }

    static {
        TYPES_USING_STRING_FIELD_BY_DEFAULT = CollectionHelper.asSet(Short.class, Short.TYPE, Byte.class, Byte.TYPE);
        numericBridges = new HashMap<String, NumericFieldBridge>(12);
        numericBridges.put(Byte.class.getName(), NumericFieldBridge.BYTE_FIELD_BRIDGE);
        numericBridges.put(Byte.TYPE.getName(), NumericFieldBridge.BYTE_FIELD_BRIDGE);
        numericBridges.put(Short.class.getName(), NumericFieldBridge.SHORT_FIELD_BRIDGE);
        numericBridges.put(Short.TYPE.getName(), NumericFieldBridge.SHORT_FIELD_BRIDGE);
        numericBridges.put(Integer.class.getName(), NumericFieldBridge.INT_FIELD_BRIDGE);
        numericBridges.put(Integer.TYPE.getName(), NumericFieldBridge.INT_FIELD_BRIDGE);
        numericBridges.put(Long.class.getName(), NumericFieldBridge.LONG_FIELD_BRIDGE);
        numericBridges.put(Long.TYPE.getName(), NumericFieldBridge.LONG_FIELD_BRIDGE);
        numericBridges.put(Double.class.getName(), NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        numericBridges.put(Double.TYPE.getName(), NumericFieldBridge.DOUBLE_FIELD_BRIDGE);
        numericBridges.put(Float.class.getName(), NumericFieldBridge.FLOAT_FIELD_BRIDGE);
        numericBridges.put(Float.TYPE.getName(), NumericFieldBridge.FLOAT_FIELD_BRIDGE);
    }
}

