/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldMapping;
import org.hibernate.search.cfg.NormalizerDefMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

public class FieldBridgeMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;
    private final PropertyDescriptor property;
    private final FieldMapping fieldMapping;
    private final Map<String, Object> bridge = new HashMap<String, Object>();

    public FieldBridgeMapping(Class<?> impl, Map<String, Object> field, FieldMapping fieldMapping, PropertyDescriptor property, EntityDescriptor entity, SearchMapping mapping) {
        this.mapping = mapping;
        this.entity = entity;
        this.property = property;
        this.fieldMapping = fieldMapping;
        this.bridge.put("impl", impl);
        field.put("bridge", this.bridge);
    }

    public FieldBridgeMapping param(String name, String value) {
        Map<String, Object> param = SearchMapping.addElementToAnnotationArray(this.bridge, "params");
        param.put("name", name);
        param.put("value", value);
        return this;
    }

    public FieldMapping name(String fieldName) {
        return this.fieldMapping.name(fieldName);
    }

    public FieldMapping store(Store store) {
        return this.fieldMapping.store(store);
    }

    public FieldMapping index(Index index) {
        return this.fieldMapping.index(index);
    }

    public FieldMapping termVector(TermVector termVector) {
        return this.fieldMapping.termVector(termVector);
    }

    public FieldMapping boost(float boost) {
        return this.fieldMapping.boost(boost);
    }

    public FieldMapping analyzer(Class<?> analyzerClass) {
        return this.fieldMapping.analyzer(analyzerClass);
    }

    public FieldMapping analyzer(String analyzerDef) {
        return this.fieldMapping.analyzer(analyzerDef);
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return this.analyzerDef(name, "", tokenizerFactory);
    }

    public AnalyzerDefMapping analyzerDef(String name, String tokenizerName, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerName, tokenizerFactory, this.mapping);
    }

    public NormalizerDefMapping normalizerDef(String name) {
        return new NormalizerDefMapping(name, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }
}

