/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.List;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ImmutableSearchIntegration;
import org.hibernate.search.engine.impl.MutableAnalyzerRegistry;
import org.hibernate.search.engine.impl.MutableNormalizerRegistry;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.spi.IndexFamilyImplementor;
import org.hibernate.search.indexes.spi.IndexManagerType;

public final class SearchIntegrationConfigContext {
    private final AnalyzerStrategy analyzerStrategy;
    private final MutableAnalyzerRegistry analyzerRegistry;
    private final MutableNormalizerRegistry normalizerRegistry;
    private final IndexFamilyImplementor indexFamily;

    public SearchIntegrationConfigContext(IndexManagerType type, ServiceManager serviceManager, SearchConfiguration searchConfiguration) {
        this(type, serviceManager, searchConfiguration, null);
    }

    public SearchIntegrationConfigContext(IndexManagerType type, ServiceManager serviceManager, SearchConfiguration searchConfiguration, SearchIntegration previousIntegrationState) {
        this.indexFamily = previousIntegrationState == null ? type.createIndexFamily(serviceManager, searchConfiguration) : previousIntegrationState.getIndexFamily();
        this.analyzerStrategy = this.indexFamily.createAnalyzerStrategy();
        this.analyzerRegistry = new MutableAnalyzerRegistry(this.analyzerStrategy, previousIntegrationState == null ? null : previousIntegrationState.getAnalyzerRegistry());
        this.normalizerRegistry = new MutableNormalizerRegistry(this.analyzerStrategy, previousIntegrationState == null ? null : previousIntegrationState.getNormalizerRegistry());
    }

    public MissingValueStrategy getMissingValueStrategy() {
        return this.indexFamily.getMissingValueStrategy();
    }

    public MutableAnalyzerRegistry getAnalyzerRegistry() {
        return this.analyzerRegistry;
    }

    public MutableNormalizerRegistry getNormalizerRegistry() {
        return this.normalizerRegistry;
    }

    public ImmutableSearchIntegration initialize(Map<String, AnalyzerDef> mappingAnalyzerDefs, Map<String, NormalizerDef> mappingNormalizerDefs) {
        List<AnalyzerReference> analyzerReferences = this.analyzerRegistry.getAllReferences();
        List<AnalyzerReference> normalizerReferences = this.normalizerRegistry.getAllReferences();
        this.analyzerStrategy.initializeReferences(analyzerReferences, mappingAnalyzerDefs, normalizerReferences, mappingNormalizerDefs);
        return new ImmutableSearchIntegration(this.indexFamily, this.analyzerRegistry, this.normalizerRegistry);
    }
}

