/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.ModelOnlyRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.security.LegacySupport;
import org.jboss.as.security.LoginModuleResourceDefinition;
import org.jboss.as.security.SecurityExtension;
import org.jboss.dmr.ModelNode;

class ACLResourceDefinition
extends SimpleResourceDefinition {
    public static final ACLResourceDefinition INSTANCE = new ACLResourceDefinition();
    public static final ListAttributeDefinition ACL_MODULES = new LegacySupport.LoginModulesAttributeDefinition("acl-modules", "acl-module");
    private static final OperationStepHandler LEGACY_ADD_HANDLER = new LegacySupport.LegacyModulesConverter("acl-module", ACL_MODULES);

    private ACLResourceDefinition() {
        super(SecurityExtension.ACL_PATH, (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("acl"), (OperationStepHandler)new ACLResourceDefinitionAdd(), (OperationStepHandler)ModelOnlyRemoveStepHandler.INSTANCE);
        this.setDeprecated(SecurityExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)ACL_MODULES, (OperationStepHandler)new LegacySupport.LegacyModulesAttributeReader("acl-module"), (OperationStepHandler)new LegacySupport.LegacyModulesAttributeWriter("acl-module"));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        ManagementResourceRegistration moduleReg = resourceRegistration.registerSubModel((ResourceDefinition)new LoginModuleResourceDefinition("acl-module"));
        resourceRegistration.registerAlias(PathElement.pathElement((String)"login-module"), new AliasEntry(moduleReg){

            public PathAddress convertToTargetAddress(PathAddress address, AliasEntry.AliasContext aliasContext) {
                PathElement element = address.getLastElement();
                element = PathElement.pathElement((String)"acl-module", (String)element.getValue());
                return address.subAddress(0, address.size() - 1).append(new PathElement[]{element});
            }
        });
    }

    static class ACLResourceDefinitionAdd
    extends AbstractAddStepHandler {
        ACLResourceDefinitionAdd() {
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            if (operation.hasDefined(ACL_MODULES.getName())) {
                context.addStep(new ModelNode(), operation, LEGACY_ADD_HANDLER, OperationContext.Stage.MODEL, true);
            }
        }
    }
}

