/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.wildfly.common.Assert;
import org.wildfly.naming.client._private.Messages;

public class SimpleName
implements Name,
Serializable {
    private static final long serialVersionUID = -91630190623885257L;
    private final ArrayList<String> segments;

    public SimpleName() {
        this.segments = new ArrayList();
    }

    public SimpleName(String name) throws InvalidNameException {
        this(SimpleName.parse(name));
    }

    public SimpleName(Collection<String> segments) {
        this(new ArrayList<String>(segments));
    }

    public SimpleName(Name name) {
        this(name.getAll());
    }

    private SimpleName(ArrayList<String> literalSegments) {
        for (int i = 0; i < literalSegments.size(); ++i) {
            if (literalSegments.get(i) != null) continue;
            throw Messages.log.invalidNullSegment(i);
        }
        this.segments = literalSegments;
    }

    public SimpleName(Enumeration<String> enumeration) {
        this();
        if (enumeration.hasMoreElements()) {
            ArrayList<String> segments = this.segments;
            int idx = 0;
            do {
                String item;
                if ((item = enumeration.nextElement()) == null) {
                    throw Messages.log.invalidNullSegment(idx);
                }
                segments.add(item);
                ++idx;
            } while (enumeration.hasMoreElements());
        }
    }

    private static ArrayList<String> parse(String name) throws InvalidNameException {
        ArrayList<String> segments = new ArrayList<String>();
        int length = name.length();
        StringBuilder b = new StringBuilder();
        int ch = -1;
        boolean q = false;
        boolean e = false;
        boolean sq = false;
        int i = 0;
        while (i < length) {
            ch = name.codePointAt(i);
            if (e) {
                e = false;
                b.appendCodePoint(ch);
            } else if (q) {
                if (sq && ch == 39) {
                    q = false;
                } else if (!sq && ch == 34) {
                    q = false;
                } else if (ch == 92) {
                    e = true;
                } else {
                    b.appendCodePoint(ch);
                }
            } else if (ch == 47) {
                segments.add(b.toString());
                b.setLength(0);
            } else if (ch == 34) {
                q = true;
                sq = false;
            } else if (ch == 39) {
                q = true;
                sq = true;
            } else if (ch == 92) {
                e = true;
            } else {
                b.appendCodePoint(ch);
            }
            i = name.offsetByCodePoints(i, 1);
        }
        if (b.length() > 0 || ch == 47) {
            segments.add(b.toString());
        }
        if (q) {
            throw Messages.log.missingCloseQuote(sq ? (char)'\'' : '\"', name);
        }
        if (e) {
            throw Messages.log.missingEscape(name);
        }
        return segments;
    }

    @Override
    public int compareTo(Object obj) {
        return this.compareTo((SimpleName)obj);
    }

    @Override
    public int compareTo(SimpleName simpleName) {
        ArrayList<String> segments = this.segments;
        ArrayList<String> theirSegments = simpleName.segments;
        int theirSize = theirSegments.size();
        int ourSize = segments.size();
        for (int i = 0; i < Math.min(ourSize, theirSize); ++i) {
            int result = segments.get(i).compareTo(theirSegments.get(i));
            if (result == 0) continue;
            return result;
        }
        return Integer.signum(ourSize - theirSize);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.equals((SimpleName)obj);
    }

    public boolean equals(SimpleName simpleName) {
        return simpleName != null && simpleName.getClass() == this.getClass() && this.segments.equals(simpleName.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    @Override
    public int size() {
        return this.segments.size();
    }

    @Override
    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        return Collections.enumeration(this.segments);
    }

    public String toString() {
        Iterator<String> iterator = this.segments.iterator();
        if (iterator.hasNext()) {
            StringBuilder b = new StringBuilder();
            SimpleName.appendSegment(b, iterator.next());
            while (iterator.hasNext()) {
                b.append('/');
                SimpleName.appendSegment(b, iterator.next());
            }
            return b.toString();
        }
        return "";
    }

    private static void appendSegment(StringBuilder b, String segment) {
        int i = 0;
        while (i < segment.length()) {
            int cp = segment.codePointAt(i);
            if (cp == 47 || cp == 39 || cp == 34) {
                b.append('\\');
            }
            b.appendCodePoint(cp);
            i = segment.offsetByCodePoints(i, 1);
        }
    }

    @Override
    public String get(int pos) {
        ArrayList<String> segments = this.segments;
        if (pos < 0 || pos >= segments.size()) {
            throw Messages.log.nameIndexOutOfBounds(pos);
        }
        return segments.get(pos);
    }

    public Collection<String> getRange(int start, int end) {
        return this.segments.subList(start, end);
    }

    @Override
    public SimpleName getPrefix(int pos) {
        return new SimpleName(this.getRange(0, pos));
    }

    @Override
    public SimpleName getSuffix(int pos) {
        return new SimpleName(this.getRange(pos, this.size()));
    }

    @Override
    public boolean startsWith(Name name) {
        ArrayList<String> segments = this.segments;
        int size = name.size();
        if (size > segments.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (segments.get(i).equals(name.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(Name name) {
        int ourSize;
        ArrayList<String> segments = this.segments;
        int size = name.size();
        if (size > (ourSize = segments.size())) {
            return false;
        }
        int offs = ourSize - size;
        for (int i = 0; i < size; ++i) {
            if (segments.get(i + offs).equals(name.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public SimpleName addAll(Name suffix) {
        if (suffix instanceof SimpleName) {
            this.segments.addAll(((SimpleName)suffix).segments);
            return this;
        }
        ArrayList<String> segments = this.segments;
        int size = suffix.size();
        int ourSize = segments.size();
        segments.ensureCapacity(ourSize + size);
        for (int i = 0; i < size; ++i) {
            this.add(suffix.get(i));
        }
        return this;
    }

    @Override
    public SimpleName addAll(int pos, Name name) {
        if (name instanceof SimpleName) {
            this.segments.addAll(pos, ((SimpleName)name).segments);
            return this;
        }
        ArrayList<String> segments = this.segments;
        int size = name.size();
        int ourSize = segments.size();
        segments.ensureCapacity(ourSize + size);
        for (int i = 0; i < size; ++i) {
            this.add(pos + i, name.get(i));
        }
        return this;
    }

    @Override
    public SimpleName add(String comp) {
        Assert.checkNotNullParam("comp", comp);
        this.segments.add(comp);
        return this;
    }

    @Override
    public SimpleName add(int pos, String comp) {
        Assert.checkNotNullParam("comp", comp);
        this.segments.add(pos, comp);
        return this;
    }

    @Override
    public String remove(int pos) {
        return this.segments.remove(pos);
    }

    @Override
    public SimpleName clone() {
        return new SimpleName((Collection<String>)this.segments);
    }

    public static SimpleName of(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        return new SimpleName(name);
    }
}

