/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.security.auth.login.ParseException;
import org.jboss.security.auth.login.SimpleCharStream;
import org.jboss.security.auth.login.SunConfigParserConstants;
import org.jboss.security.auth.login.SunConfigParserTokenManager;
import org.jboss.security.auth.login.Token;
import org.jboss.security.auth.login.XMLLoginConfigImpl;

public class SunConfigParser
implements SunConfigParserConstants {
    private XMLLoginConfigImpl loginConfig;
    public SunConfigParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[6];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int trace_indent = 0;
    private boolean trace_enabled = true;

    public SunConfigParser() {
        this(new StringReader(""));
    }

    public void parse(Reader configFile, XMLLoginConfigImpl loginConfig) throws ParseException {
        this.parse(configFile, loginConfig, false);
    }

    public void parse(Reader configFile, XMLLoginConfigImpl loginConfig, boolean trace) throws ParseException {
        this.ReInit(configFile);
        if (trace) {
            this.enable_tracing();
        } else {
            this.disable_tracing();
        }
        this.loginConfig = loginConfig;
        this.config();
    }

    private String stripQuotes(String image) {
        return image.substring(1, image.length() - 1);
    }

    public static void doParse(Reader configFile, XMLLoginConfigImpl loginConfig) throws ParseException {
        SunConfigParser.doParse(configFile, loginConfig, false);
    }

    public static void doParse(Reader configFile, XMLLoginConfigImpl loginConfig, boolean trace) throws ParseException {
        SunConfigParser parser = new SunConfigParser();
        parser.parse(configFile, loginConfig, trace);
    }

    public final void config() throws ParseException {
        this.trace_call("config");
        try {
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block6;
                    }
                }
                this.appConfig();
            }
            this.jj_consume_token(0);
        }
        finally {
            this.trace_return("config");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appConfig() throws ParseException {
        this.trace_call("appConfig");
        try {
            Token t = null;
            ArrayList<AppConfigurationEntry> entries = new ArrayList<AppConfigurationEntry>();
            t = this.jj_consume_token(16);
            String appName = t.image;
            this.jj_consume_token(7);
            block6: while (true) {
                AppConfigurationEntry entry = this.loginModuleConfig();
                entries.add(entry);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        continue block6;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(8);
            this.jj_consume_token(9);
            AppConfigurationEntry[] appConfig = new AppConfigurationEntry[entries.size()];
            entries.toArray(appConfig);
            this.loginConfig.addAppConfig(appName, appConfig);
        }
        finally {
            this.trace_return("appConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppConfigurationEntry loginModuleConfig() throws ParseException {
        this.trace_call("loginModuleConfig");
        try {
            AppConfigurationEntry entry;
            Token t = null;
            HashMap<String, String> optionsMap = new HashMap<String, String>();
            t = this.jj_consume_token(17);
            String loginModuleClassName = t.image;
            AppConfigurationEntry.LoginModuleControlFlag controlFlag = this.controlFlag();
            block6: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: 
                    case 17: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block6;
                    }
                }
                this.moduleOptions(optionsMap);
            }
            this.jj_consume_token(9);
            AppConfigurationEntry appConfigurationEntry = entry = new AppConfigurationEntry(loginModuleClassName, controlFlag, optionsMap);
            return appConfigurationEntry;
        }
        finally {
            this.trace_return("loginModuleConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppConfigurationEntry.LoginModuleControlFlag controlFlag() throws ParseException {
        this.trace_call("controlFlag");
        try {
            AppConfigurationEntry.LoginModuleControlFlag flag = null;
            Token t = this.jj_consume_token(15);
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.toString().indexOf(t.image) > 0) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.toString().indexOf(t.image) > 0) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.toString().indexOf(t.image) > 0) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.toString().indexOf(t.image) > 0) {
                flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
            AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = flag;
            return loginModuleControlFlag;
        }
        finally {
            this.trace_return("controlFlag");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void moduleOptions(HashMap<String, String> optionsMap) throws ParseException {
        this.trace_call("moduleOptions");
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    t = this.jj_consume_token(16);
                    break;
                }
                case 17: {
                    t = this.jj_consume_token(17);
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            String name = t.image;
            this.jj_consume_token(10);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 20: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 16: {
                            t = this.jj_consume_token(16);
                            break;
                        }
                        case 17: {
                            t = this.jj_consume_token(17);
                            break;
                        }
                        case 12: {
                            t = this.jj_consume_token(12);
                            break;
                        }
                        case 11: {
                            t = this.jj_consume_token(11);
                            break;
                        }
                        case 20: {
                            t = this.jj_consume_token(20);
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    String value = t.image;
                    optionsMap.put(name, value);
                    return;
                }
                case 14: {
                    t = this.jj_consume_token(14);
                    String value = this.stripQuotes(t.image);
                    optionsMap.put(name, value);
                    return;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            this.trace_return("moduleOptions");
        }
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{65536, 131072, 196608, 196608, 1251328, 1267712};
    }

    public SunConfigParser(InputStream stream) {
        this(stream, null);
    }

    public SunConfigParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SunConfigParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SunConfigParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SunConfigParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SunConfigParser(SunConfigParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SunConfigParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 6; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            this.trace_token(this.token, "");
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        this.trace_token(this.token, " (in getNextToken)");
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[22];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 6; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 22; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
        this.trace_enabled = true;
    }

    public final void disable_tracing() {
        this.trace_enabled = false;
    }

    private void trace_call(String s) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Call:   " + s);
        }
        this.trace_indent += 2;
    }

    private void trace_return(String s) {
        this.trace_indent -= 2;
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.println("Return: " + s);
        }
    }

    private void trace_token(Token t, String where) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Consumed token: <" + tokenImage[t.kind]);
            if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
                System.out.print(": \"" + t.image + "\"");
            }
            System.out.println(" at line " + t.beginLine + " column " + t.beginColumn + ">" + where);
        }
    }

    private void trace_scan(Token t1, int t2) {
        if (this.trace_enabled) {
            for (int i = 0; i < this.trace_indent; ++i) {
                System.out.print(" ");
            }
            System.out.print("Visited token: <" + tokenImage[t1.kind]);
            if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
                System.out.print(": \"" + t1.image + "\"");
            }
            System.out.println(" at line " + t1.beginLine + " column " + t1.beginColumn + ">; Expected token: <" + tokenImage[t2] + ">");
        }
    }

    static {
        SunConfigParser.jj_la1_init_0();
    }
}

