/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.datasource.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.security.SimpleGroup;

class SubjectActions {
    SubjectActions() {
    }

    static void addCredentials(Subject subject, PasswordCredential cred) {
        AddCredentialsAction action = new AddCredentialsAction(subject, cred);
        AccessController.doPrivileged(action);
    }

    static void addPrincipals(Subject subject, Principal p) {
        AddPrincipalsAction action = new AddPrincipalsAction(subject, p);
        AccessController.doPrivileged(action);
    }

    static void removeCredentials(Subject subject) {
        RemoveCredentialsAction action = new RemoveCredentialsAction(subject);
        AccessController.doPrivileged(action);
    }

    static void addRoles(Subject subject, Set<Principal> runAsRoles) {
        if (System.getSecurityManager() != null) {
            AddRolesActions.PRIVILEGED.addRoles(subject, runAsRoles);
        } else {
            AddRolesActions.NON_PRIVILEGED.addRoles(subject, runAsRoles);
        }
    }

    private static Group addSubjectRoles(Subject theSubject, Set<Principal> roles) {
        Set<Group> subjectGroups = theSubject.getPrincipals(Group.class);
        Iterator<Group> iter = subjectGroups.iterator();
        SimpleGroup roleGrp = null;
        while (iter.hasNext()) {
            Group grp = iter.next();
            String name = grp.getName();
            if (!name.equals("Roles")) continue;
            roleGrp = grp;
        }
        if (roleGrp == null) {
            roleGrp = new SimpleGroup("Roles");
            theSubject.getPrincipals().add(roleGrp);
        }
        for (Principal role : roles) {
            roleGrp.addMember(role);
        }
        return roleGrp;
    }

    static class RemoveCredentialsAction
    implements PrivilegedAction<Void> {
        Subject subject;

        RemoveCredentialsAction(Subject subject) {
            this.subject = subject;
        }

        @Override
        public Void run() {
            Iterator<PasswordCredential> i = this.subject.getPrivateCredentials(PasswordCredential.class).iterator();
            while (i.hasNext()) {
                i.remove();
            }
            return null;
        }
    }

    static class AddPrincipalsAction
    implements PrivilegedAction<Void> {
        Subject subject;
        Principal p;

        AddPrincipalsAction(Subject subject, Principal p) {
            this.subject = subject;
            this.p = p;
        }

        @Override
        public Void run() {
            this.subject.getPrincipals().add(this.p);
            return null;
        }
    }

    static class AddCredentialsAction
    implements PrivilegedAction<Void> {
        Subject subject;
        PasswordCredential cred;

        AddCredentialsAction(Subject subject, PasswordCredential cred) {
            this.subject = subject;
            this.cred = cred;
        }

        @Override
        public Void run() {
            this.subject.getPrivateCredentials().add(this.cred);
            return null;
        }
    }

    static interface AddRolesActions {
        public static final AddRolesActions PRIVILEGED = new AddRolesActions(){

            @Override
            public void addRoles(final Subject subject, final Set<Principal> roles) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        SubjectActions.addSubjectRoles(subject, roles);
                        return null;
                    }
                });
            }
        };
        public static final AddRolesActions NON_PRIVILEGED = new AddRolesActions(){

            @Override
            public void addRoles(Subject subject, Set<Principal> roles) {
                SubjectActions.addSubjectRoles(subject, roles);
            }
        };

        public void addRoles(Subject var1, Set<Principal> var2);
    }
}

