/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.health;

import java.util.List;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.health.ServerProbe;

class ServerProbes {
    private static final ModelNode READ_SERVER_STATE_ATTRIBUTE = new ModelNode();
    private static final ModelNode READ_BOOT_ERRORS;
    private static final ModelNode READ_DEPLOYMENTS_STATUS;

    ServerProbes() {
    }

    static {
        READ_SERVER_STATE_ATTRIBUTE.get("operation").set("read-attribute");
        READ_SERVER_STATE_ATTRIBUTE.get("address").set(new ModelNode());
        READ_SERVER_STATE_ATTRIBUTE.get("name").set("server-state");
        READ_BOOT_ERRORS = new ModelNode();
        READ_BOOT_ERRORS.get("operation").set("read-boot-errors");
        READ_BOOT_ERRORS.get("address").add("core-service", "management");
        READ_DEPLOYMENTS_STATUS = new ModelNode();
        READ_DEPLOYMENTS_STATUS.get("operation").set("read-attribute");
        READ_DEPLOYMENTS_STATUS.get("address").add("deployment", "*");
        READ_DEPLOYMENTS_STATUS.get("name").set("status");
    }

    static class DeploymentsStatusCheck
    implements ServerProbe {
        private LocalModelControllerClient modelControllerClient;

        DeploymentsStatusCheck(LocalModelControllerClient modelControllerClient) {
            this.modelControllerClient = modelControllerClient;
        }

        @Override
        public ServerProbe.Outcome getOutcome() {
            ModelNode responses = this.modelControllerClient.execute(READ_DEPLOYMENTS_STATUS);
            if (!"success".equals(responses.get("outcome").asStringOrNull())) {
                return ServerProbe.Outcome.FAILURE;
            }
            if (!responses.get("result").isDefined()) {
                return ServerProbe.Outcome.FAILURE;
            }
            ModelNode data = new ModelNode();
            boolean globalStatus = true;
            for (ModelNode response : responses.get("result").asList()) {
                String value;
                boolean deploymentUp = false;
                String info = null;
                if (!"success".equals(response.get("outcome").asStringOrNull())) {
                    info = "DMR Query failed";
                } else if (response.hasDefined("failure-description")) {
                    info = response.get("failure-description").asString();
                }
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    info = "status undefined";
                }
                if ("OK".equals(value = result.asString())) {
                    deploymentUp = true;
                }
                if (info == null) {
                    info = value;
                }
                PathAddress address = PathAddress.pathAddress((ModelNode)response.get("address"));
                String deploymentName = address.getElement(0).getValue();
                data.add(deploymentName, info);
                globalStatus = globalStatus && deploymentUp;
            }
            return new ServerProbe.Outcome(globalStatus, data);
        }

        @Override
        public String getName() {
            return "deployments-status";
        }
    }

    static class NoBootErrorsCheck
    implements ServerProbe {
        private LocalModelControllerClient modelControllerClient;

        NoBootErrorsCheck(LocalModelControllerClient modelControllerClient) {
            this.modelControllerClient = modelControllerClient;
        }

        @Override
        public ServerProbe.Outcome getOutcome() {
            ModelNode response = this.modelControllerClient.execute(READ_BOOT_ERRORS);
            if (!"success".equals(response.get("outcome").asStringOrNull())) {
                return ServerProbe.Outcome.FAILURE;
            }
            if (response.hasDefined("failure-description")) {
                ModelNode data = new ModelNode();
                data.add("failure-description", response.get("failure-description").asString());
                return new ServerProbe.Outcome(false, data);
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return ServerProbe.Outcome.FAILURE;
            }
            List errors = result.asList();
            if (errors.isEmpty()) {
                return ServerProbe.Outcome.SUCCESS;
            }
            ModelNode data = new ModelNode();
            data.add("boot-errors", result.toJSONString(true));
            return new ServerProbe.Outcome(false, data);
        }

        @Override
        public String getName() {
            return "boot-errors";
        }
    }

    static class ServerStateCheck
    implements ServerProbe {
        private LocalModelControllerClient modelControllerClient;

        public ServerStateCheck(LocalModelControllerClient modelControllerClient) {
            this.modelControllerClient = modelControllerClient;
        }

        @Override
        public ServerProbe.Outcome getOutcome() {
            ModelNode response = this.modelControllerClient.execute(READ_SERVER_STATE_ATTRIBUTE);
            if (!"success".equals(response.get("outcome").asStringOrNull())) {
                return ServerProbe.Outcome.FAILURE;
            }
            if (response.hasDefined("failure-description")) {
                ModelNode data = new ModelNode();
                data.add("failure-description", response.get("failure-description").asString());
                return new ServerProbe.Outcome(false, data);
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                return ServerProbe.Outcome.FAILURE;
            }
            String value = result.asString();
            ModelNode data = new ModelNode();
            data.add("value", value);
            return new ServerProbe.Outcome("running".equals(value), data);
        }

        @Override
        public String getName() {
            return "server-state";
        }
    }
}

