/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.DisplaySecret;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.adduser.UpdatePropertiesHandler;

public class AddUserState
extends UpdatePropertiesHandler
implements State {
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public AddUserState(ConsoleWrapper theConsole, StateValues stateValues) {
        super(theConsole);
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    public State execute() {
        String password = this.stateValues.getPassword();
        State nextState = password == null ? new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.noPasswordExiting(), null, this.stateValues) : this.update(this.stateValues);
        if (nextState == null && this.stateValues.isInteractive()) {
            nextState = new ConfirmationChoice(this.theConsole, DomainManagementMessages.MESSAGES.serverUser(), DomainManagementMessages.MESSAGES.yesNo(), (State)new DisplaySecret(this.theConsole, this.stateValues), null);
        }
        return nextState;
    }

    @Override
    String consoleUserMessage(String filePath) {
        return DomainManagementMessages.MESSAGES.addedUser(this.stateValues.getUserName(), filePath);
    }

    @Override
    String consoleGroupsMessage(String filePath) {
        return DomainManagementMessages.MESSAGES.addedGroups(this.stateValues.getUserName(), this.stateValues.getGroups(), filePath);
    }

    @Override
    String errorMessage(String filePath, Throwable e) {
        return DomainManagementMessages.MESSAGES.unableToAddUser(filePath, e.getMessage());
    }
}

