/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.adduser.ConfirmationChoice;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.DisplaySecret;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.as.domain.management.security.adduser.UpdatePropertiesHandler;

public class UpdateUser
extends UpdatePropertiesHandler
implements State {
    private final StateValues stateValues;
    private final ConsoleWrapper theConsole;

    public UpdateUser(ConsoleWrapper theConsole, StateValues stateValues) {
        super(theConsole);
        this.theConsole = theConsole;
        this.stateValues = stateValues;
    }

    @Override
    public State execute() {
        State nextState = this.update(this.stateValues);
        if (nextState == null && this.stateValues.isInteractive() && this.stateValues.getPassword() != null) {
            nextState = new ConfirmationChoice(this.theConsole, DomainManagementMessages.MESSAGES.serverUser(), DomainManagementMessages.MESSAGES.yesNo(), (State)new DisplaySecret(this.theConsole, this.stateValues), null);
        }
        return nextState;
    }

    @Override
    String consoleUserMessage(String fileName) {
        return DomainManagementMessages.MESSAGES.updateUser(this.stateValues.getUserName(), fileName);
    }

    @Override
    String consoleGroupsMessage(String fileName) {
        return DomainManagementMessages.MESSAGES.updatedGroups(this.stateValues.getUserName(), this.stateValues.getGroups(), fileName);
    }

    @Override
    String errorMessage(String fileName, Throwable e) {
        return DomainManagementMessages.MESSAGES.unableToUpdateUser(fileName, e.getMessage());
    }
}

