/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.adduser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.as.domain.management.security.UserPropertiesFileLoader;
import org.jboss.as.domain.management.security.adduser.AddUser;
import org.jboss.as.domain.management.security.adduser.ConsoleWrapper;
import org.jboss.as.domain.management.security.adduser.ErrorState;
import org.jboss.as.domain.management.security.adduser.PromptNewUserState;
import org.jboss.as.domain.management.security.adduser.PromptRealmState;
import org.jboss.as.domain.management.security.adduser.State;
import org.jboss.as.domain.management.security.adduser.StateValues;
import org.jboss.msc.service.StartException;

public class PropertyFileFinder
implements State {
    private ConsoleWrapper theConsole;
    private final StateValues stateValues;

    public PropertyFileFinder(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (stateValues != null && !stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State execute() {
        this.stateValues.setKnownGroups(new HashMap<String, String>());
        if (this.stateValues.getOptions().getGroupProperties() != null && this.stateValues.getOptions().getUserProperties() == null) {
            return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.groupPropertiesButNoUserProperties(this.stateValues.getOptions().getGroupProperties()), null, this.stateValues);
        }
        ArrayList<File> foundFiles = new ArrayList<File>(2);
        String fileName = this.stateValues.getOptions().getUserProperties();
        String string = fileName == null ? (this.stateValues.getFileMode() == AddUser.FileMode.MANAGEMENT ? "mgmt-users.properties" : "application-users.properties") : (fileName = fileName);
        if (!this.findFiles(foundFiles, fileName)) {
            return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.propertiesFileNotFound(fileName), null, this.stateValues);
        }
        fileName = this.stateValues.getOptions().getGroupProperties();
        if (fileName != null || this.stateValues.getFileMode() != AddUser.FileMode.UNDEFINED) {
            boolean groupFileMandatory = true;
            ArrayList<File> foundGroupFiles = new ArrayList<File>(2);
            if (fileName == null && this.stateValues.getFileMode() == AddUser.FileMode.APPLICATION) {
                fileName = "application-roles.properties";
            } else if (fileName == null) {
                fileName = "mgmt-groups.properties";
                groupFileMandatory = false;
            }
            String string2 = fileName = fileName == null ? "application-roles.properties" : fileName;
            if (!this.findFiles(foundGroupFiles, fileName) && groupFileMandatory) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.propertiesFileNotFound(fileName), null, this.stateValues);
            }
            this.stateValues.setGroupFiles(foundGroupFiles);
            try {
                this.stateValues.setKnownGroups(this.loadAllGroups(foundGroupFiles));
            }
            catch (Exception e) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.propertiesFileNotFound(fileName), null, this.stateValues);
            }
        }
        this.stateValues.setUserFiles(foundFiles);
        String realmName = null;
        HashSet<String> enabledFoundUsers = new HashSet<String>();
        HashSet<String> disabledFoundUsers = new HashSet<String>();
        for (File current : this.stateValues.getUserFiles()) {
            UserPropertiesFileLoader pfl = null;
            try {
                pfl = this.loadUsersFile(current);
                enabledFoundUsers.addAll(pfl.getEnabledUserNames());
                disabledFoundUsers.addAll(pfl.getDisabledUserNames());
                if (realmName == null) {
                    realmName = pfl.getRealmName();
                } else {
                    String nextRealm = pfl.getRealmName();
                    if (!realmName.equals(nextRealm)) {
                        ErrorState errorState = new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.multipleRealmsDetected(realmName, nextRealm), null, this.stateValues);
                        return errorState;
                    }
                }
                pfl.stop(null);
                pfl = null;
            }
            catch (IOException e) {
                ErrorState errorState = new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.unableToLoadUsers(current.getAbsolutePath(), e.getMessage()), null, this.stateValues);
                return errorState;
            }
            finally {
                if (pfl == null) continue;
                pfl.stop(null);
                pfl = null;
            }
        }
        if (realmName != null) {
            if (this.stateValues.getRealmMode() == AddUser.RealmMode.USER_SUPPLIED && !realmName.equals(this.stateValues.getRealm())) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.userRealmNotMatchDiscovered(this.stateValues.getRealm(), realmName), null, this.stateValues);
            }
            this.stateValues.setRealm(realmName);
            this.stateValues.setRealmMode(AddUser.RealmMode.DISCOVERED);
        }
        this.stateValues.setEnabledKnownUsers(enabledFoundUsers);
        this.stateValues.setDisabledKnownUsers(disabledFoundUsers);
        return this.stateValues.isInteractive() ? new PromptRealmState(this.theConsole, this.stateValues) : new PromptNewUserState(this.theConsole, this.stateValues);
    }

    private UserPropertiesFileLoader loadUsersFile(File file) throws IOException {
        UserPropertiesFileLoader fileLoader = new UserPropertiesFileLoader(file.getAbsolutePath());
        try {
            fileLoader.start(null);
        }
        catch (StartException e) {
            throw new IOException(e);
        }
        return fileLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadAllGroups(List<File> foundGroupsFiles) throws StartException, IOException {
        HashMap<String, String> loadedGroups = new HashMap<String, String>();
        for (File file : foundGroupsFiles) {
            PropertiesFileLoader propertiesLoad = null;
            try {
                propertiesLoad = new PropertiesFileLoader(file.getCanonicalPath());
                propertiesLoad.start(null);
                loadedGroups.putAll(propertiesLoad.getProperties());
            }
            finally {
                if (propertiesLoad == null) continue;
                propertiesLoad.stop(null);
            }
        }
        return loadedGroups;
    }

    private boolean findFiles(List<File> foundFiles, String fileName) {
        File domainProps;
        File standaloneProps;
        File singleFile = new File(fileName);
        if (singleFile.exists()) {
            foundFiles.add(singleFile);
            return true;
        }
        String serverConfigOpt = this.stateValues.getOptions().getServerConfigDir();
        String domainConfigOpt = this.stateValues.getOptions().getDomainConfigDir();
        if (serverConfigOpt == null && domainConfigOpt == null) {
            File domainProps2;
            standaloneProps = this.buildFilePath("jboss.server.config.user.dir", this.stateValues.getOptions().getServerConfigDir(), "jboss.server.config.dir", "jboss.server.base.dir", "standalone", fileName);
            if (standaloneProps.exists()) {
                foundFiles.add(standaloneProps);
            }
            if ((domainProps2 = this.buildFilePath("jboss.domain.config.user.dir", this.stateValues.getOptions().getDomainConfigDir(), "jboss.domain.config.dir", "jboss.domain.base.dir", "domain", fileName)).exists()) {
                foundFiles.add(domainProps2);
            }
        }
        if (serverConfigOpt != null && (standaloneProps = this.buildFilePath("jboss.server.config.user.dir", this.stateValues.getOptions().getServerConfigDir(), "jboss.server.config.dir", "jboss.server.base.dir", "standalone", fileName)).exists()) {
            foundFiles.add(standaloneProps);
        }
        if (domainConfigOpt != null && (domainProps = this.buildFilePath("jboss.domain.config.user.dir", this.stateValues.getOptions().getDomainConfigDir(), "jboss.domain.config.dir", "jboss.domain.base.dir", "domain", fileName)).exists()) {
            foundFiles.add(domainProps);
        }
        return !foundFiles.isEmpty();
    }

    private File buildFilePath(String serverConfigUserDirPropertyName, String suppliedConfigDir, String serverConfigDirPropertyName, String serverBaseDirPropertyName, String defaultBaseDir, String fileName) {
        return new File(this.buildDirPath(serverConfigUserDirPropertyName, suppliedConfigDir, serverConfigDirPropertyName, serverBaseDirPropertyName, defaultBaseDir), fileName);
    }

    private File buildDirPath(String serverConfigUserDirPropertyName, String suppliedConfigDir, String serverConfigDirPropertyName, String serverBaseDirPropertyName, String defaultBaseDir) {
        String propertyDir = System.getProperty(serverConfigUserDirPropertyName);
        if (propertyDir != null) {
            return new File(propertyDir);
        }
        if (suppliedConfigDir != null) {
            return new File(suppliedConfigDir);
        }
        propertyDir = System.getProperty(serverConfigDirPropertyName);
        if (propertyDir != null) {
            return new File(propertyDir);
        }
        propertyDir = System.getProperty(serverBaseDirPropertyName);
        if (propertyDir != null) {
            return new File(propertyDir);
        }
        return new File(new File(this.stateValues.getOptions().getJBossHome(), defaultBaseDir), "configuration");
    }
}

