/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class BasicComponentInstance
implements ComponentInstance {
    private static final long serialVersionUID = -8099216228976950066L;
    public static final Object INSTANCE_KEY = BasicComponentInstanceKey.class;
    private final BasicComponent component;
    private final Interceptor preDestroy;
    private volatile int done;
    private static final AtomicIntegerFieldUpdater<BasicComponentInstance> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(BasicComponentInstance.class, "done");
    private transient Map<Method, Interceptor> methodMap;
    private Map<Object, Object> instanceData = new HashMap<Object, Object>();
    private volatile boolean constructionFinished = false;

    protected BasicComponentInstance(BasicComponent component, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        this.component = component;
        this.preDestroy = preDestroyInterceptor;
        this.methodMap = Collections.unmodifiableMap(methodInterceptors);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Object getInstance() {
        ManagedReference managedReference = (ManagedReference)this.getInstanceData(INSTANCE_KEY);
        if (managedReference == null) {
            return null;
        }
        return managedReference.getInstance();
    }

    @Override
    public Interceptor getInterceptor(Method method) throws IllegalStateException {
        Interceptor interceptor = this.methodMap.get(method);
        if (interceptor == null) {
            throw EeLogger.ROOT_LOGGER.methodNotFound(method);
        }
        return interceptor;
    }

    @Override
    public Collection<Method> allowedMethods() {
        return this.methodMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        if (doneUpdater.compareAndSet(this, 0, 1)) {
            try {
                this.preDestroy();
                Object instance = this.getInstance();
                if (instance != null) {
                    InterceptorContext interceptorContext = this.prepareInterceptorContext();
                    interceptorContext.setTarget(instance);
                    interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.PRE_DESTROY);
                    this.preDestroy.processInvocation(interceptorContext);
                }
            }
            catch (Exception e) {
                EeLogger.ROOT_LOGGER.componentDestroyFailure(e, this);
            }
            finally {
                this.component.finishDestroy();
            }
        }
    }

    @Override
    public Object getInstanceData(Object key) {
        return this.instanceData.get(key);
    }

    @Override
    public void setInstanceData(Object key, Object value) {
        if (this.constructionFinished) {
            throw EeLogger.ROOT_LOGGER.instanceDataCanOnlyBeSetDuringConstruction();
        }
        this.instanceData.put(key, value);
    }

    public void constructionFinished() {
        this.constructionFinished = true;
    }

    protected void preDestroy() {
    }

    protected InterceptorContext prepareInterceptorContext() {
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.putPrivateData(Component.class, (Object)this.component);
        interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
        interceptorContext.setContextData(new HashMap());
        return interceptorContext;
    }

    private static class BasicComponentInstanceKey
    implements Serializable {
        private BasicComponentInstanceKey() {
        }
    }
}

