/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.HashMap;
import java.util.Map;

enum Attribute {
    UNKNOWN(null),
    NAME("name"),
    SLOT("slot"),
    ANNOTATIONS("annotations"),
    SERVICES("services"),
    META_INF("meta-inf"),
    JNDI_NAME("jndi-name"),
    USE_TRANSACTION_SETUP_PROVIDER("use-transaction-setup-provider"),
    CONTEXT_SERVICE("context-service"),
    PRIORITY("priority"),
    THREAD_FACTORY("thread-factory"),
    HUNG_TASK_THRESHOLD("hung-task-threshold"),
    LONG_RUNNING_TASKS("long-running-tasks"),
    CORE_THREADS("core-threads"),
    MAX_THREADS("max-threads"),
    KEEPALIVE_TIME("keepalive-time"),
    QUEUE_LENGTH("queue-length"),
    REJECT_POLICY("reject-policy"),
    DATASOURCE("datasource"),
    JMS_CONNECTION_FACTORY("jms-connection-factory"),
    MANAGED_EXECUTOR_SERVICE("managed-executor-service"),
    MANAGED_SCHEDULED_EXECUTOR_SERVICE("managed-scheduled-executor-service"),
    MANAGED_THREAD_FACTORY("managed-thread-factory");

    private final String name;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.getLocalName();
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

