/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deliveryactive.metadata.EJBBoundDeliveryActiveMetaData;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.DeliveryActive;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class DeliveryActiveMergingProcessor
extends AbstractMergingProcessor<MessageDrivenComponentDescription> {
    public DeliveryActiveMergingProcessor() {
        super(MessageDrivenComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation deliveryActive = clazz.getAnnotationInformation(DeliveryActive.class);
        if (deliveryActive == null) {
            return;
        }
        if (!deliveryActive.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setDeliveryActive((Boolean)deliveryActive.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, MessageDrivenComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        String ejbName = componentConfiguration.getEJBName();
        EjbJarMetaData metaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (metaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = metaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        Boolean deliveryActive = null;
        List deliveryActiveDataList = assemblyDescriptor.getAny(EJBBoundDeliveryActiveMetaData.class);
        if (deliveryActiveDataList != null) {
            for (EJBBoundDeliveryActiveMetaData deliveryActiveData : deliveryActiveDataList) {
                if ("*".equals(deliveryActiveData.getEjbName()) && deliveryActive == null) {
                    deliveryActive = deliveryActiveData.isDeliveryActive();
                    continue;
                }
                if (!ejbName.equals(deliveryActiveData.getEjbName())) continue;
                deliveryActive = deliveryActiveData.isDeliveryActive();
            }
        }
        if (deliveryActive != null) {
            componentConfiguration.setDeliveryActive(deliveryActive);
        }
    }
}

