/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop.stub;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.jboss.as.ejb3.iiop.stub.DynamicIIOPStub;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.util.Boxing;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.wildfly.iiop.openjdk.rmi.AttributeAnalysis;
import org.wildfly.iiop.openjdk.rmi.ExceptionAnalysis;
import org.wildfly.iiop.openjdk.rmi.InterfaceAnalysis;
import org.wildfly.iiop.openjdk.rmi.OperationAnalysis;
import org.wildfly.iiop.openjdk.rmi.RMIIIOPViolationException;
import org.wildfly.iiop.openjdk.rmi.marshal.CDRStream;
import org.wildfly.iiop.openjdk.rmi.marshal.strategy.StubStrategy;

public class IIOPStubCompiler {
    public static final String ID_FIELD_NAME = "$ids";

    private static String strategy(int methodIndex) {
        return "$s" + methodIndex;
    }

    private static String init(int methodIndex) {
        return "$i" + methodIndex;
    }

    private static void generateMethodCode(ClassFile asm, Class<?> superclass, Method m, String idlName, String strategyField, String initMethod) {
        int j;
        int i;
        Class<?> returnType = m.getReturnType();
        Class<?>[] paramTypes = m.getParameterTypes();
        Class<?>[] exceptions = m.getExceptionTypes();
        asm.addField(10, strategyField, StubStrategy.class);
        CodeAttribute ca = asm.addMethod(m).getCodeAttribute();
        ca.aload(0);
        ca.ldc(idlName);
        ca.getstatic(asm.getName(), strategyField, StubStrategy.class);
        if (paramTypes.length == 0) {
            ca.iconst(0);
            ca.anewarray(Object.class.getName());
        } else {
            ca.iconst(paramTypes.length);
            ca.anewarray(Object.class.getName());
            int index = 1;
            for (int j2 = 0; j2 < paramTypes.length; ++j2) {
                Class<?> type = paramTypes[j2];
                ca.dup();
                ca.iconst(j2);
                if (!type.isPrimitive()) {
                    ca.aload(index);
                } else if (type.equals(Double.TYPE)) {
                    ca.dload(index);
                    Boxing.boxDouble((CodeAttribute)ca);
                    ++index;
                } else if (type.equals(Long.TYPE)) {
                    ca.lload(index);
                    Boxing.boxLong((CodeAttribute)ca);
                    ++index;
                } else if (type.equals(Float.TYPE)) {
                    ca.fload(index);
                    Boxing.boxFloat((CodeAttribute)ca);
                } else {
                    ca.iload(index);
                    Boxing.boxIfNessesary((CodeAttribute)ca, (String)DescriptorUtils.makeDescriptor(type));
                }
                ++index;
                ca.aastore();
            }
        }
        String invoke = "invoke";
        String ret = "Ljava/lang/Object;";
        if (returnType.isPrimitive() && returnType != Void.TYPE) {
            String typeName = returnType.getName();
            invoke = invoke + Character.toUpperCase(typeName.charAt(0)) + typeName.substring(1);
            ret = DescriptorUtils.makeDescriptor(returnType);
        }
        ca.invokevirtual(superclass.getName(), invoke, "(Ljava/lang/String;Lorg/wildfly/iiop/openjdk/rmi/marshal/strategy/StubStrategy;[Ljava/lang/Object;)" + ret);
        if (!returnType.isPrimitive() && returnType != Object.class) {
            ca.checkcast(returnType);
        }
        ca.returnInstruction();
        CodeAttribute init = asm.addMethod(10, initMethod, "V", new String[0]).getCodeAttribute();
        int len = paramTypes.length;
        init.iconst(len);
        init.anewarray(String.class.getName());
        for (i = 0; i < len; ++i) {
            init.dup();
            init.iconst(i);
            init.ldc(CDRStream.abbrevFor(paramTypes[i]));
            init.aastore();
        }
        len = exceptions.length;
        int n = 0;
        for (i = 0; i < len; ++i) {
            if (RemoteException.class.isAssignableFrom(exceptions[i])) continue;
            ++n;
        }
        init.iconst(n);
        init.anewarray(String.class.getName());
        try {
            j = 0;
            for (i = 0; i < len; ++i) {
                if (RemoteException.class.isAssignableFrom(exceptions[i])) continue;
                init.dup();
                init.iconst(j);
                init.ldc(ExceptionAnalysis.getExceptionAnalysis(exceptions[i]).getExceptionRepositoryId());
                init.aastore();
                ++j;
            }
        }
        catch (RMIIIOPViolationException e) {
            throw new RuntimeException("Cannot obtain exception repository id for " + exceptions[i].getName() + ":\n" + (Object)((Object)e));
        }
        init.iconst(n);
        init.anewarray(String.class.getName());
        j = 0;
        for (i = 0; i < len; ++i) {
            if (RemoteException.class.isAssignableFrom(exceptions[i])) continue;
            init.dup();
            init.iconst(j);
            init.ldc(exceptions[i].getName());
            init.aastore();
            ++j;
        }
        init.ldc(CDRStream.abbrevFor(returnType));
        init.aconstNull();
        init.invokestatic(StubStrategy.class.getName(), "forMethod", "([Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/ClassLoader;)Lorg/wildfly/iiop/openjdk/rmi/marshal/strategy/StubStrategy;");
        init.putstatic(asm.getName(), strategyField, StubStrategy.class);
        init.returnInstruction();
    }

    private static ClassFile generateCode(InterfaceAnalysis interfaceAnalysis, Class<?> superclass, String stubClassName) {
        ClassFile asm = new ClassFile(stubClassName, superclass.getName(), new String[]{interfaceAnalysis.getCls().getName()});
        int methodIndex = 0;
        AttributeAnalysis[] attrs = interfaceAnalysis.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            OperationAnalysis op = attrs[i].getAccessorAnalysis();
            IIOPStubCompiler.generateMethodCode(asm, superclass, op.getMethod(), op.getIDLName(), IIOPStubCompiler.strategy(methodIndex), IIOPStubCompiler.init(methodIndex));
            ++methodIndex;
            op = attrs[i].getMutatorAnalysis();
            if (op == null) continue;
            IIOPStubCompiler.generateMethodCode(asm, superclass, op.getMethod(), op.getIDLName(), IIOPStubCompiler.strategy(methodIndex), IIOPStubCompiler.init(methodIndex));
            ++methodIndex;
        }
        OperationAnalysis[] ops = interfaceAnalysis.getOperations();
        for (int i = 0; i < ops.length; ++i) {
            IIOPStubCompiler.generateMethodCode(asm, superclass, ops[i].getMethod(), ops[i].getIDLName(), IIOPStubCompiler.strategy(methodIndex), IIOPStubCompiler.init(methodIndex));
            ++methodIndex;
        }
        ClassMethod ctor = asm.addMethod(1, "<init>", "V", new String[0]);
        ctor.getCodeAttribute().aload(0);
        ctor.getCodeAttribute().invokespecial(superclass.getName(), "<init>", "()V");
        ctor.getCodeAttribute().returnInstruction();
        String[] ids = interfaceAnalysis.getAllTypeIds();
        asm.addField(10, ID_FIELD_NAME, String[].class);
        CodeAttribute idMethod = asm.addMethod(17, "_ids", "[Ljava/lang/String;", new String[0]).getCodeAttribute();
        idMethod.getstatic(stubClassName, ID_FIELD_NAME, "[Ljava/lang/String;");
        idMethod.returnInstruction();
        CodeAttribute clinit = asm.addMethod(8, "<clinit>", "V", new String[0]).getCodeAttribute();
        clinit.iconst(ids.length);
        clinit.anewarray(String.class.getName());
        for (int i = 0; i < ids.length; ++i) {
            clinit.dup();
            clinit.iconst(i);
            clinit.ldc(ids[i]);
            clinit.aastore();
        }
        clinit.putstatic(stubClassName, ID_FIELD_NAME, "[Ljava/lang/String;");
        int n = methodIndex;
        for (methodIndex = 0; methodIndex < n; ++methodIndex) {
            clinit.invokestatic(stubClassName, IIOPStubCompiler.init(methodIndex), "()V");
        }
        clinit.returnInstruction();
        return asm;
    }

    private static ClassFile makeCode(InterfaceAnalysis interfaceAnalysis, Class<?> superclass, String stubClassName) {
        ClassFile code = IIOPStubCompiler.generateCode(interfaceAnalysis, superclass, stubClassName);
        return code;
    }

    public static ClassFile compile(Class<?> intf, String stubClassName) {
        InterfaceAnalysis interfaceAnalysis = null;
        try {
            interfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(intf);
        }
        catch (RMIIIOPViolationException e) {
            throw new RuntimeException("RMI/IIOP Violation:\n" + (Object)((Object)e));
        }
        return IIOPStubCompiler.makeCode(interfaceAnalysis, DynamicIIOPStub.class, stubClassName);
    }

    public Class<?> compileToClass(Class<?> intf, String stubClassName) {
        return IIOPStubCompiler.compile(intf, stubClassName).define(intf.getClassLoader(), intf.getProtectionDomain());
    }
}

