/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron.oidc;

import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.security.VirtualDomainUtil;
import org.jboss.as.server.security.VirtualSecurityDomainCreationService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.elytron.oidc.ElytronOidcExtension;
import org.wildfly.extension.elytron.oidc.ElytronOidcSubsystemAdd;
import org.wildfly.extension.elytron.oidc.ProviderDefinition;
import org.wildfly.extension.elytron.oidc.RealmDefinition;
import org.wildfly.extension.elytron.oidc.SecureDeploymentDefinition;

class ElytronOidcSubsystemDefinition
extends PersistentResourceDefinition {
    static final String CONFIG_CAPABILITY_NAME = "org.wildlfly.elytron.oidc";
    static final String ELYTRON_CAPABILITY_NAME = "org.wildfly.security.elytron";
    static final RuntimeCapability<Void> CONFIG_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildlfly.elytron.oidc").setServiceType(Void.class).addRequirements(new String[]{"org.wildfly.security.elytron"}).build();

    protected ElytronOidcSubsystemDefinition() {
        super(new SimpleResourceDefinition.Parameters(ElytronOidcExtension.SUBSYSTEM_PATH, ElytronOidcExtension.getResourceDescriptionResolver(new String[0])).setAddHandler((OperationStepHandler)new ElytronOidcSubsystemAdd()).setRemoveHandler((OperationStepHandler)ElytronOidcSubsystemRemove.INSTANCE).setCapabilities(new RuntimeCapability[]{CONFIG_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.emptySet();
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new RealmDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new ProviderDefinition());
        resourceRegistration.registerSubModel((ResourceDefinition)new SecureDeploymentDefinition());
    }

    static void installService(ServiceName serviceName, Service<?> service, ServiceTarget serviceTarget) {
        serviceTarget.addService(serviceName, service).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private static class ElytronOidcSubsystemRemove
    extends ReloadRequiredRemoveStepHandler {
        static final ElytronOidcSubsystemRemove INSTANCE = new ElytronOidcSubsystemRemove();

        private ElytronOidcSubsystemRemove() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (context.isResourceServiceRestartAllowed()) {
                context.removeService(VirtualDomainUtil.OIDC_VIRTUAL_SECURITY_DOMAIN_CREATION_SERVICE);
            } else {
                context.reloadRequired();
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget target = context.getServiceTarget();
            ElytronOidcSubsystemDefinition.installService(VirtualDomainUtil.VIRTUAL_SECURITY_DOMAIN_CREATION_SERVICE, new VirtualSecurityDomainCreationService(), target);
        }
    }
}

