/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Principal;
import java.util.Locale;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.principal.AnonymousPrincipal;

class PoolAuthenticationContext {
    private static final AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
    private volatile Type current;

    PoolAuthenticationContext() {
    }

    boolean handleResponse(ClientResponse response) {
        if (response.getResponseCode() != 401) {
            return false;
        }
        String authenticate = response.getResponseHeaders().getFirst(Headers.WWW_AUTHENTICATE);
        if (authenticate == null) {
            return false;
        }
        if (authenticate.toLowerCase(Locale.ENGLISH).startsWith("basic ")) {
            this.current = Type.BASIC;
            return true;
        }
        return false;
    }

    boolean prepareRequest(URI uri, ClientRequest request, AuthenticationConfiguration authenticationConfiguration) {
        if (this.current == Type.BASIC) {
            Principal principal;
            AuthenticationConfiguration config = authenticationConfiguration;
            if (config == null) {
                config = AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, AuthenticationContext.captureCurrent());
            }
            if ((principal = AUTH_CONTEXT_CLIENT.getPrincipal(config)) instanceof AnonymousPrincipal) {
                return false;
            }
            PasswordCallback callback = new PasswordCallback("password", false);
            try {
                AUTH_CONTEXT_CLIENT.getCallbackHandler(config).handle(new Callback[]{callback});
            }
            catch (IOException | UnsupportedCallbackException e) {
                return false;
            }
            char[] password = callback.getPassword();
            if (password == null) {
                return false;
            }
            String challenge = principal.getName() + ":" + new String(password);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, "Basic " + FlexBase64.encodeString((byte[])challenge.getBytes(StandardCharsets.UTF_8), (boolean)false));
            return true;
        }
        return false;
    }

    static enum Type {
        NONE,
        BASIC,
        DIGEST;

    }
}

